<script type="text/javascript">

    $(function () {
        var importantNoteHeader = '<span style="color:white;"> <span class="fa fa-bell-o fa-2x"'
            + 'style="vertical-align:middle;padding-right:10px;">'
            + '</span>' + '{!! trans('fi.important') !!}' + '</span>';

        $('#modal-enter-payment').modal();

        $("#payment_date").datetimepicker({
            format: dateFormat,
            autoclose: true,
            todayHighlight: true
        });

        calculationPaymentTerm('{{$paymentDetails['type']}}');

        function calculationPaymentTerm(type)
        {
            let payment_term_data = {};
            let form_data;
            payment_term_data['client_id'] = $('#client_id').val();
            payment_term_data['invoice_id'] = $('#invoice_id').val();
            payment_term_data['amount'] = $('#payment_amount').val();
            payment_term_data['paymentTermIsApply'] = '{{$paymentTermIsApply ? 'true' : 'false'}}';
            payment_term_data['payment_term_type'] = '{{$paymentDetails['type']}}';
            payment_term_data['percentage'] = '{{$paymentDetails['percentage']}}';
            payment_term_data['paymentDetailsAmountValue'] = '{{$paymentDetails['amountValue']}}';
            payment_term_data['type'] = '{{$paymentDetails['type']}}';
            payment_term_data['invoice_balance'] = $('#invoice_balance').data('amount');
            @if($paymentTermIsApply)
            if ('{{$paymentDetails['type']}}' == 2 || '{{$paymentDetails['type']}}' == 3)
            {
                payment_term_data['payment_term_discount'] = $('#payment_term_discount').val() || 0;
                payment_term_data['payment_term_checkbox'] = (($('#payment-term-checkbox').prop('checked')) ? true : false);
                payment_term_data['final_payable_amount'] = $('#final_payable_amount').val();
            }
            if ('{{$paymentDetails['type']}}' == 5)
            {
                payment_term_data['installment'] = '{{$paymentDetails['installment']}}';
            }
            @endif
                payment_term_data['currency_code'] = $('#currency_code').val();

            form_data = objectToFormData(payment_term_data);
            $.ajax({
                url: '{{ route('payments.store.calculation') }}',
                method: 'post',
                data: form_data,
                processData: false,
                contentType: false,
                success: function (data) {
                    if (data.error)
                    {
                        alertify.error(data.error, 5);
                    }
                },
            }).done(function (response) {
                let calculation = response.calculation;
                setFormattedValue($('#remaining_balance'), calculation.remaining_balance);
                setFormattedValue($('#payment_amount'), calculation.payment_amount);
                setFormattedValue($('#payment_term_discount'), calculation.percent_Amount);
                setFormattedValue($('#final_payable_amount'), calculation.final_payable_amount);
            }).fail(function (response) {
                $this.html($this.data('original-text')).attr("disabled", false);
                showAlertifyErrors($.parseJSON(response.responseText).errors);
            });

        }

        function checkCheckboxStatus()
        {
            var isChecked = $('#payment-term-checkbox').prop('checked');
            let invoice_balance = parseFloat($('#invoice_balance').data('amount'));

            if (!isChecked)
            {
                setFormattedValue($('#payment_amount'), invoice_balance)
                $('#payment_term_discount').attr('disabled', true).val('');
                $('#final_payable_amount').attr('disabled', true).val('');

                let remaining_balance = countRemainingBalance();
                if (remaining_balance < 0)
                {
                    $('#remaining_balance').val(currencyFormat(0.00, $('#currency_code').val()));
                }
                else
                {
                    $('#remaining_balance').val(currencyFormat(remaining_balance, $('#currency_code').val()));
                }
            }
            else
            {
                setFormattedValue($('#payment_amount'), invoice_balance)
                setFormattedValue($('#payment_term_discount'), parseFloat('{{$paymentDetails['paymentTermsDiscount']}}'))
                setFormattedValue($('#final_payable_amount'), '{{$paymentDetails['amountValue']}}')
                $('#payment_term_discount').attr('disabled', false);
            }
        }


        $('#payment-term-checkbox').on('change', function () {
            checkCheckboxStatus();
        });

        $('#payment_term_discount, #payment_amount').change(function () {
            // Type 2 and 3
            calculationPaymentTerm('{{$paymentDetails['type']}}');
        });

        function currencyFormatted(value)
        {
            return currencyFormat(value, $('#currency_code').val());
        }

        function countRemainingBalance()
        {
            let invoice_balance = parseFloat($('#invoice_balance').data('amount'));

            let entered_amount = parseFloat(currencyUnformat($('#payment_amount').val(), $('#currency_code').val()));

            let remaining_balance = (invoice_balance - entered_amount).toFixed(2);

            return remaining_balance;
        }

        @can('payments.create')
        $('#enter-payment-confirm').click(function () {
            showHideLoaderModal();
            var $this = $(this);
            $this.html('<i class="fa fa-circle-o-notch fa-spin"></i> ' + $this.data('loading-text')).attr("disabled", true);

            setTimeout(() => {
                $this = $('#enter-payment-confirm');
                $this.html($this.data('original-text')).attr("disabled", false);
                showHideLoaderModal();

                var payment_data = {};
                var form_data;
                var custom_fields = {};
                var selectCustomRadioButtonValue = null;

                let entered_amount = parseFloat(standardCurrencyFormat($('#payment_amount').val()));
                if (entered_amount <= 0)
                {
                    alertify.alert().setHeader(importantNoteHeader).set({transition: 'zoom'})
                        .setContent("{!! trans('fi.payment_warning') !!}").showModal();
                    return false;
                }

                $this.html('<i class="fa fa-circle-o-notch fa-spin"></i> ' + $this.data('loading-text')).attr("disabled", true);

                $('#payment-custom-fields .custom-form-field').each(function () {


                    var fieldName = $(this).data('payments-field-name');
                    var inputType = $(this).attr('type') || this.tagName.toLowerCase();
                    if (fieldName !== undefined)
                    {
                        if ('file' === inputType)
                        {
                            custom_fields[fieldName] = typeof this.files[0] === 'undefined' ? '' : this.files[0];
                            return true;
                        }

                        if ('select' === inputType)
                        {
                            if ($(this).find('option:selected').length == 0)
                            {
                                custom_fields[fieldName] = '';
                                return true;
                            }
                        }
                        if ('checkbox' === inputType)
                        {
                            custom_fields[fieldName] = ($(this).is(":checked")) ? 1 : 0;
                            return true;
                        }

                        if ('radio' === inputType)
                        {
                            if ($(this).prop('checked') == true)
                            {
                                custom_fields[fieldName] = $(this).val();
                                selectCustomRadioButtonValue = $(this).val();
                            }
                            if ($(this).prop('checked') == false && selectCustomRadioButtonValue == null)
                            {
                                custom_fields[fieldName] = 'null';
                            }
                            return custom_fields[fieldName];
                        }

                        custom_fields[fieldName] = $(this).val();
                    }

                });


                payment_data['client_id'] = $('#client_id').val();
                payment_data['invoice_id'] = $('#invoice_id').val();
                payment_data['amount'] = currencyFormatted($('#payment_amount').data('value'));
                payment_data['paymentTermIsApply'] = '{{$paymentTermIsApply ? 'true' : 'false'}}';
                payment_data['payment_term_type'] = '{{$paymentDetails['type']}}';
                @if($paymentTermIsApply)
                if ('{{$paymentDetails['type']}}' == 2 || '{{$paymentDetails['type']}}' == 3)
                {
                    payment_data['payment_term_discount'] = currencyFormatted($('#payment_term_discount').data('value') || 0);
                    payment_data['payment_term_checkbox'] = (($('#payment-term-checkbox').prop('checked')) ? true : false);
                    payment_data['final_payable_amount'] = currencyFormatted($('#final_payable_amount').data('value'));
                }
                if ('{{$paymentDetails['type']}}' == 5)
                {
                    payment_data['installment'] = '{{$paymentDetails['installment']}}';
                }
                @endif

                payment_data['remaining_balance'] = currencyFormatted($('#remaining_balance').data('value'));
                payment_data['payment_method_id'] = $('#payment_method_id').val();
                payment_data['paid_at'] = $('#payment_date').children().val();
                payment_data['note'] = $('#payment_note').val();
                payment_data['custom'] = custom_fields;
                payment_data['email_payment_receipt'] = ($('#email_payment_receipt').prop('checked')) ? 1 : 0;
                payment_data['currency_code'] = $('#currency_code').val();

                if (($('#payment_term_discount').data('value') || 0) < $('#payment_amount').data('value'))
                {
                    form_data = objectToFormData(payment_data);
                    $.ajax({
                        url: '{{ route('payments.store') }}',
                        method: 'post',
                        data: form_data,
                        processData: false,
                        contentType: false,
                        success: function (data) {
                            if (data.error)
                            {
                                alertify.error(data.error, 5);
                            }
                        },
                    }).done(function () {
                        window.location = '{!! $redirectTo !!}';
                    }).fail(function (response) {
                        $this.html($this.data('original-text')).attr("disabled", false);
                        showAlertifyErrors($.parseJSON(response.responseText).errors);
                    });
                }
                else
                {
                    $this.html($this.data('original-text')).attr("disabled", false);
                    alertify.error('{{trans('fi.term_amount_gt_payment_amount')}}', 5);
                }
            }, 2000);
        });
        @endcan

    });

</script>
