@extends('layouts.master')

@section('head')
    @include('layouts._select2')
@stop
@section('content')
    @include('layouts._bootstrap_icon_picker')

    <style>
        .pulse {
            display: block;
            width: 100%;
            cursor: pointer;
            box-shadow: 0 0 0 rgba(204, 169, 44, 0.4);
            animation: pulse 2s infinite;
        }

        .pulse:hover {
            animation: none;
        }

        @-webkit-keyframes pulse {
            0% {
                -webkit-box-shadow: 0 0 0 0 rgba(204, 169, 44, 0.4);
            }
            70% {
                -webkit-box-shadow: 0 0 0 10px rgba(204, 169, 44, 0);
            }
            100% {
                -webkit-box-shadow: 0 0 0 0 rgba(204, 169, 44, 0);
            }
        }

        @keyframes pulse {
            0% {
                -moz-box-shadow: 0 0 0 0 rgba(204, 169, 44, 0.4);
                box-shadow: 0 0 0 0 rgba(204, 169, 44, 0.4);
            }
            70% {
                -moz-box-shadow: 0 0 0 10px rgba(204, 169, 44, 0);
                box-shadow: 0 0 0 10px rgba(204, 169, 44, 0);
            }
            100% {
                -moz-box-shadow: 0 0 0 0 rgba(204, 169, 44, 0);
                box-shadow: 0 0 0 0 rgba(204, 169, 44, 0);
            }
        }
    </style>
    <script type="text/javascript">
        $(function () {
            var discountAction = $('.down_payment_type').iconpicker();

            discountAction.iconpicker('setIconset', {
                iconClass: 'fa',
                icons: [
                    'fa-money-bill',
                    'fa-percentage',
                ]
            }).iconpicker('setSearch', false).iconpicker('setRows', 1);


            var mainDownPaymentTypeIcon = $("#down_payment_type").data('icon');

            iconClassSet($("#down_payment_type"), mainDownPaymentTypeIcon);

            function iconClassSet($this, mainDownPaymentTypeIcon)
            {
                switch (mainDownPaymentTypeIcon)
                {
                    case 'fa-money-bill':
                        $this.iconpicker('setIcon', 'fa-money-bill');
                        break;
                    case 'fa-percentage':
                        $this.iconpicker('setIcon', 'fa-percentage');
                        break;
                    default:
                        $this.iconpicker('setIcon', 'fa-money-bill');
                        break;
                }
            }

            @if(!isset($paymentTerm))
            {{--$('#name').val('{{ trans('fi.net_amount_due_in_n_days')}}');--}}
            $("#payment-term-one").prop("checked", true);
            $("input[name='net_due_days_1']").attr("disabled", true);
            @endif

            $('.back-btn-payment-term').click(function () {
                window.location.replace('{{$redirect}}');
            });

            $('.form-payment-term').submit(function (evt) {
                $('.conform-btn-payment-term').attr('disabled', true);
                evt.stopPropagation();
                evt.preventDefault();
                var formAllData = $(this).serialize();

                $.post($(this).attr('action'), formAllData).done(function (response) {
                    window.location.replace(response.redirect);
                }).fail(function (response) {
                    $('.conform-btn-payment-term').attr('disabled', false);
                    var errors = $.parseJSON(response.responseText).errors;
                    $.each(errors, function (key, messages) {
                        $.each(messages, function (index, message) {
                            alertify.error(message, 5);
                        });
                    });

                });
            });


            $('#number-of-installments-five').change(function () {
                paymentSplitOverInstallment();
            });

            function paymentSplitOverInstallment()
            {
                var old_number = parseInt($('.payment-installments').children().length);
                var $_html = null;
                var number = parseInt($('#number-of-installments-five').val());
                var flag = false;
                var demo_html = $('.payment-installments-demo').html();

                for (let $i = 1; $i <= parseInt(number); $i++)
                {
                    let result = demo_html.replace(/replace/gi, $i);
                    if ($i > old_number && number > old_number)
                    {
                        $('.payment-installments').append(result);
                        flag = false;
                    }
                    else
                    {
                        if ($_html !== null)
                        {
                            $_html += result;
                        }
                        else
                        {
                            $_html = result;
                        }
                        flag = true;
                    }
                }
                if (flag == true)
                {
                    $('.payment-installments').html($_html);
                }
                setInstallmentPercent();

            }

            function paymentSplitInstallment()
            {
                if ($("input[name='type']:checked").val() == 5)
                {
                    $('.display-none-payment-split').removeClass('d-none').addClass('d-block');
                }
                else
                {
                    $('.display-none-payment-split').addClass('d-none').removeClass('d-block');
                }
            }

            function setInstallmentPercent()
            {
                let old_number = parseInt($('.payment-installments').children().length);
                let number = parseInt(old_number);
                let percent = parseFloat(100 / number);

                for (let $i = 1; $i <= number; $i++)
                {
                    $("input[name='installment_percent_" + $i + "']").val(percent);
                }
            }

            paymentSplitOverInstallment();

            $("input[name='type']").change(function () {
                $('#number-of-installments-five').val(1)
                if ($(this).val() != 5)
                {
                    paymentSplitOverInstallment();
                }
                isCheckPaymentTermType();
                paymentSplitInstallment();
            });
            paymentSplitInstallment();
            isCheckPaymentTermType();

            function isCheckPaymentTermType()
            {
                $("input[name='type']").not(":checked").next().children().find(".payment-term-input").val('').prop("disabled", true);
                $("input[name='type']:checked").next().children().find(".payment-term-input").prop("disabled", false);
            }

            setInstallmentPercent();
            @if(isset($paymentTerm) && count($paymentTerm->installments) > 0)
            @foreach($paymentTerm->installments as $installment)
            $("input[name='type']:checked").next().children().find("input[name='installment_percent_" + {{$installment->installment_number}} + "']").val('{{$installment->installment_percent}}')
            $("input[name='type']:checked").next().children().find("input[name='installment_due_days_" + {{$installment->installment_number}} + "']").val('{{$installment->installment_due_days}}')
            @endforeach
            @endif

            let typeOfInput;
            $(document).on('change', "input,#number-of-installments-five", function () {
                var num = $("input[name='type']:checked").val();
                typeOfInput = $(this).prop("type")
                typeNotice(num);
            });

            typeNotice($("input[name='type']:checked").val());

            function typeNotice(type)
            {
                let html = $('.dynamic-message');

                let description_template = $('#description_template');
                let quote_description_template = $('#quote_description_template');

                html.text('');
                var day;
                if (type == 1)
                {
                    var mess = '{!! trans('fi.1_type') !!}';
                    day = ($('#net-due-days-one').val() != '') ? $('#net-due-days-one').val() : 0;
                    mess = mess.replace('#N', day);
                    html.append(mess);

                    var des_mess = "{!! trans('fi.t_1_description') !!}";

                    description_template.val(des_mess);
                    quote_description_template.val('{{trans('fi.t_1_description_for_quote')}}');

                }
                else if (type == 2)
                {
                    var mess = '{!! trans('fi.2_type') !!}';
                    var discount = ($('#discount-percent-two').val() != '') ? $('#discount-percent-two').val() : 0;
                    var discount_day = ($('#discount-days-simple-two').val() != '') ? $('#discount-days-simple-two').val() : 0;
                    var date = '{{ \Illuminate\Support\Carbon::now()->format('Y-m-d')}}';
                    var dateNew = (moment(moment(date).add(discount_day, 'd').format('YYYY-MM-DD')).format(dateFormat));
                    day = ($('#net-due-days-two').val() != '') ? $('#net-due-days-two').val() : 0;
                    mess = mess.replace('#N', day);
                    mess = mess.replace('#date', dateNew);
                    html.append(mess);

                    var des_mess = '{!! trans('fi.t_2_description') !!}';
                    description_template.val(des_mess);
                    quote_description_template.val('{{trans('fi.t_2_description_for_quote')}}');

                }
                else if (type == 3)
                {
                    var discount3 = ($('#discount-percent-three').val() != '') ? $('#discount-percent-three').val() : 0;
                    var nth_day3 = ($('#discount-days-nth-three').val() != '') ? parseInt($('#discount-days-nth-three').val()) - 1 : 0;
                    var net_due_day_3 = ($('#net-due-days-three').val() != '') ? parseInt($('#net-due-days-three').val()) : 0;
                    var date3 = '{{ \Illuminate\Support\Carbon::now()->format('Y-m-d')}}';
                    let daysInNextMonth = moment(date3).add(1, 'month').endOf('month').date();
                    var mess = '{!! trans('fi.3_type') !!}';
                    let dateNew3 = (moment(date3).add(1, 'month').startOf('month').add(nth_day3, 'days').format(dateFormat));
                    if (daysInNextMonth > nth_day3)
                    {
                        mess = mess.replace('#N', net_due_day_3);
                        mess = mess.replace('#date', dateNew3);
                        html.append(mess);

                        var des_mess = '{!! trans('fi.t_3_description') !!}';
                        description_template.val(des_mess);
                        quote_description_template.val('{{trans('fi.t_3_description_for_quote')}}');
                    }
                    else
                    {
                        var error_mess = '{!! trans('fi.payment_term_messages.3_type_error') !!}';
                        error_mess = error_mess.replaceAll('#N', daysInNextMonth);
                        $('#discount-days-nth-three').val('');
                        html.append(error_mess);
                    }
                }
                else if (type == 4)
                {
                    var mess = '{!! trans('fi.4_type') !!}';
                    let down_payment_type = $("#down_payment_type").children('input').val();
                    var amount = ($('#discount-payment-four').val() != '') ? $('#discount-payment-four').val() : 0;
                    day = ($('#balance-due-days-four').val() != '') ? $('#balance-due-days-four').val() : 0;
                    mess = mess.replace('#N', day);
                    if (down_payment_type == 'fa-percentage')
                    {
                        amount = amount + ' %'
                    }
                    mess = mess.replace('#amount', amount);
                    html.append(mess);

                    var des_mess = '{!! trans('fi.t_4_description') !!}';
                    var des_mess_percentage = '{!! trans('fi.t_4_1_description') !!}';

                    var quote_des_mess = '{!! trans('fi.t_4_description_for_quote') !!}';
                    var quote_des_mess_percentage = '{!! trans('fi.t_4_1_description_for_quote') !!}';

                    if (down_payment_type == 'fa-percentage')
                    {
                        description_template.val(des_mess_percentage);
                        quote_description_template.val(quote_des_mess_percentage);
                    }
                    else
                    {
                        description_template.val(des_mess);
                        quote_description_template.val(quote_des_mess);
                    }

                }
                else if (type == 5)
                {
                    var mess = [];
                    var installments = ($('#number-of-installments-five').val() != '') ? $('#number-of-installments-five').val() : 0;
                    var messInstallment1 = '{!! trans('fi.5_type') !!}';
                    var installmentText = installments == 1 ? '{{ trans('fi.installment') }}' : '{{ trans('fi.installments') }}';
                    messInstallment1 = messInstallment1.replace('#months', installments);
                    messInstallment1 = messInstallment1.replace('#installment', installmentText);
                    mess.push(messInstallment1);

                    var des_mess = [];
                    var des_mess_for_quote = [];
                    var des_5_mess = '{!! trans('fi.t_5_description') !!}';
                    des_mess.push(des_5_mess)
                    des_mess_for_quote.push(des_5_mess)

                    for (let $i = 1; $i <= installments; $i++)
                    {
                        var messInstallment = '{!! trans('fi.5_1_type') !!}';
                        var percent = ($("#installment_percent_" + $i).val() != '') ? parseFloat($("#installment_percent_" + $i).val()).toFixed(2) : 0;
                        var installment_due_days = ($("#installment_due_days_" + $i).val() != null) ? $("#installment_due_days_" + $i).val() : 0;
                        var date5 = '{{ \Illuminate\Support\Carbon::now()->format('Y-m-d')}}';
                        var dateNew5 = (moment(moment(date5).add(installment_due_days, 'd').format('YYYY-MM-DD')).format(dateFormat));

                        messInstallment = messInstallment.replace('#percent', percent);
                        messInstallment = messInstallment.replace('#date', dateNew5);
                        messInstallment = messInstallment.replace('#installmentnumber', $i);

                        mess.push(messInstallment);

                        var typeMess = '{!! trans('fi.t_5_type_description') !!}';
                        var typeMessForQuote = '{!! trans('fi.t_5_type_description_for_quote') !!}';

                        typeMess = typeMess.replace('#INSTALLMENTAMOUNT', '#INSTALLMENTAMOUNT' + $i);
                        typeMessForQuote = typeMessForQuote.replace('#INSTALLMENTAMOUNT', '#INSTALLMENTAMOUNT' + $i);

                        des_mess.push(typeMess)
                        des_mess_for_quote.push(typeMessForQuote)
                    }
                    html.append(mess.join(" "));

                    if (typeOfInput != 'number' && typeOfInput != 'text')
                    {
                        description_template.val(des_mess.join("\n"));
                        quote_description_template.val(des_mess_for_quote.join("\n"));
                    }
                }
            }

            $('#down_payment_type').iconpicker().on('change', function () {
                var num = $("input[name='type']:checked").val();
                typeOfInput = $(this).prop("type")
                typeNotice(num);
            });

            @if($editMode)
            var description = `{!! $paymentTerm->description_template !!}`;
            var quote_description_template = `{!! $paymentTerm->quote_description_template !!}`;
            $('#description_template').val(description);
            $('#quote_description_template').val(quote_description_template);
            @if($notEditable && $defaultPaymentId != $paymentTerm->id)
            const isEditableOrnot = () => {
                $("input[name='type']").prop("disabled", true);
                $("input").not("[name=name]").prop("disabled", true);
            }
            isEditableOrnot();
            @endif
            @endif
        });
    </script>
    @isset($paymentTerm)
        {!! Form::model($paymentTerm, ['route' => ($notEditable && $defaultPaymentId != $paymentTerm->id) ? ['payment.terms.editable.update', $paymentTerm->id] : ['payment.terms.update', $paymentTerm->id],'class'=>'form-payment-term']) !!}
    @else
        {!! Form::open(['route' => 'payment.terms.store','class'=>'form-payment-term']) !!}
    @endif

    <section class="content-header">

        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-12 d-none d-sm-block">
                    <ol class="breadcrumb float-sm-right">{!!  breadcrumbs() !!}</ol>
                </div>
            </div>
            <div class="row mb-2">

                <div class="col-sm-6">

                    <h1 class="pull-left d-inline">

                        {{ trans('fi.payment_terms') }}

                    </h1>

                </div>

                <div class="col-sm-6">

                    <div class="text-right">

                        <button type="button" class="btn btn-sm btn-default back-btn-payment-term"><i
                                    class="fa fa-backward"></i> {{ trans('fi.back') }}
                        </button>
                        <button class="btn btn-sm btn-primary conform-btn-payment-term">
                            <i class="fa fa-save"></i> {{ trans('fi.save') }}
                        </button>

                    </div>

                </div>

            </div>

        </div>

    </section>

    <section class="content">

        <div class="container-fluid">

            @include('layouts._alerts')

            <div class="row">

                <div class="col-md-12">

                    <div class="card card-primary card-outline">

                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-9">
                                    <div class="form-group">
                                        <label class="">{{ trans('fi.name') }}: </label>
                                        {!! Form::text('name', null, ['id' => 'name', 'class' => 'form-control form-control-sm']) !!}
                                    </div>
                                </div>
                                @if($editMode == false || $defaultPaymentId != $paymentTerm->id)
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="">{{ trans('fi.status') }}: </label>
                                            {!! Form::select('status', $status, null, ['id' => 'status', 'class' => 'form-control form-control-sm ']) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div class="row ">
                                                <div class="col-2">
                                                    <label class="mb-2">{{ trans('fi.type') }}:</label>
                                                </div>
                                            </div>
                                            <div class="form-check mb-3">
                                                {!! Form::radio('type', 1, null, ['id' => 'payment-term-one', 'class' => 'form-check-input']) !!}
                                                <label class="form-check-label col-12 p-0" for="payment-term-one">
                                                    <div class="row col-12">
                                                        <span class="mr-1">{{trans('fi.net_amount_due_in')}} </span>
                                                        {!! Form::number('net_due_days_1', (isset($paymentTerm->type) && $paymentTerm->type == 1) ? $paymentTerm->net_due_days : null, ['min'=>'1', 'id' => 'net-due-days-one', 'class' => 'mw-80 col-md-1 col-3 payment-term-input form-control form-control-sm net-due-days-one']) !!}
                                                        <span class="ml-1"> {{trans('fi.days')}}</span>
                                                    </div>
                                                </label>
                                            </div>
                                            <div class="form-check mb-3">
                                                {!! Form::radio('type', 2, null, ['id' => 'payment-term-two', 'class' => 'form-check-input']) !!}
                                                <label class="form-check-label col-12 p-0" for="payment-term-two">
                                                    <div class="row col-12">
                                                        <span class="mr-1">{{trans('fi.discount')}}</span>
                                                        {!! Form::text('discount_percent_2', (isset($paymentTerm->type) && $paymentTerm->type == 2 ) ? $paymentTerm->discount_percent : null, ['id' => 'discount-percent-two', 'class' => 'mw-80 col-md-1 col-3 payment-term-input form-control form-control-sm discount-percent-two']) !!}
                                                        <span class="mr-1 ml-1">
                                                            <i class="fa-think fa-percent mr-1"> </i> {{trans('fi.if_paid_within')}}
                                                        </span>
                                                        {!! Form::number('discount_days_simple_2', (isset($paymentTerm->type) && $paymentTerm->type == 2 ) ? $paymentTerm->discount_days_simple : null, ['min'=>'1', 'id' => 'discount-days-simple-two', 'class' => 'mw-80 col-md-1 col-3 payment-term-input form-control form-control-sm discount-days-simple-two']) !!}
                                                        <span class="mr-1 ml-1">{{trans('fi.days') . '. '}}  {{trans('fi.net_amount_due_in')}} </span>
                                                        {!! Form::number('net_due_days_2',  (isset($paymentTerm->type) && $paymentTerm->type == 2) ? $paymentTerm->net_due_days : null, ['min'=>'1', 'id' => 'net-due-days-two', 'class' => 'mw-80 col-md-1 col-3 payment-term-input form-control form-control-sm net-due-days-two']) !!}
                                                        <span class="ml-1"> {{trans('fi.days')}}</span>
                                                    </div>
                                                </label>
                                            </div>
                                            <div class="form-check mb-3">
                                                {!! Form::radio('type', 3, null, ['id' => 'payment-term-three', 'class' => 'form-check-input']) !!}
                                                <label class="form-check-label col-12 p-0" for="payment-term-three">
                                                    <div class="row col-12">
                                                        <span class="mr-1">{{trans('fi.discount')}}</span>
                                                        {!! Form::text('discount_percent_3', (isset($paymentTerm->type) && $paymentTerm->type == 3) ? $paymentTerm->discount_percent : null, ['id' => 'discount-percent-three', 'class' => 'mw-80 col-md-1 col-3 payment-term-input form-control form-control-sm discount-percent-three']) !!}
                                                        <span class="mr-1 ml-1">
                                                            <i class="fa-think fa-percent mr-1"> </i> {{trans('fi.if_paid_by') . ' ' .strtolower(trans('fi.day')) }}
                                                        </span>
                                                        {!! Form::number('discount_days_nth_3',  (isset($paymentTerm->type) && $paymentTerm->type == 3) ? $paymentTerm->discount_days_nth : null, ['min'=>'1', 'id' => 'discount-days-nth-three', 'class' => 'mw-80 col-md-1 col-3 payment-term-input form-control form-control-sm discount-days-nth-three']) !!}
                                                        <span class="mr-1 ml-1">{{trans('fi.of_next_month') . '.'}} {{trans('fi.net_amount_due_in')}} </span>
                                                        {!! Form::number('net_due_days_3',  (isset($paymentTerm->type) && $paymentTerm->type == 3) ? $paymentTerm->net_due_days : null, ['min'=>'1', 'id' => 'net-due-days-three', 'class' => 'mw-80 col-md-1 col-3 payment-term-input form-control form-control-sm net-due-days-three']) !!}
                                                        <span class="ml-1"> {{trans('fi.days')}}</span>
                                                    </div>
                                                </label>
                                            </div>
                                            <div class="form-check mb-3">
                                                {!! Form::radio('type', 4, null, ['id' => 'payment-term-four', 'class' => 'form-check-input']) !!}
                                                <label class="form-check-label col-12 p-0" for="payment-term-four">
                                                    <div class="row col-12">
                                                        <div class="input-group">
                                                            <span class="mr-1">{{trans('fi.down_payment_payment_term1')}}</span>
                                                            {!! Form::text('down_payment_4', (isset($paymentTerm->type) && $paymentTerm->type == 4) ? $paymentTerm->down_payment : null,
                                                                ['id' => 'discount-payment-four',
                                                                'class' => 'mw-80 col-md-1 col-3 payment-term-input form-control form-control-sm discount-payment-four']) !!}
                                                            <span class="input-group-append">
                                                                    <button class="btn btn-sm btn-secondary down_payment_type"
                                                                            type="button"
                                                                            id="down_payment_type"
                                                                            name="down_payment_type"
                                                                            data-header="false"
                                                                            data-placement="top"
                                                                            @if(isset($paymentTerm->type) && $paymentTerm->down_payment_type == 'percentage')
                                                                                data-icon="fa-percentage"
                                                                            @elseif(isset($paymentTerm->type) && $paymentTerm->down_payment_type == 'flat_amount')
                                                                                data-icon="fa-money-bill"
                                                                            @endif
                                                                            data-footer="false"
                                                                            role="iconpicker">
                                                                    </button>
                                                                </span>
                                                            <span class="mr-1 ml-1">{{trans('fi.down_payment_payment_term2')}}</span>
                                                            {!! Form::number('balance_due_days_4', (isset($paymentTerm->type) && $paymentTerm->type == 4) ? $paymentTerm->balance_due_days : null, ['min'=>'1', 'id' => 'balance-due-days-four', 'class' => 'rounded mw-80 col-md-1 col-3 payment-term-input form-control form-control-sm balance-due-days-four']) !!}
                                                            <span class="ml-1"> {{trans('fi.days')}}</span>
                                                        </div>
                                                    </div>
                                                </label>
                                            </div>
                                            <div class="form-check mb-3">
                                                {!! Form::radio('type', 5, null, ['id' => 'payment-term-five', 'class' => 'form-check-input']) !!}
                                                <label class="form-check-label col-12 p-0" for="payment-term-five">
                                                    <div class="row col-12">
                                                        <span class="mr-1">{{trans('fi.payment_split_over')}}</span>
                                                        {!! Form::select('number_of_installments_5', $numberOfInstallments, (isset($paymentTerm->type) && $paymentTerm->type == 5) ? $paymentTerm->number_of_installments : null, ['id' => 'number-of-installments-five', 'class' => 'payment-term-input mw-80 col-md-1 col-3 form-control form-control-sm number-of-installments-five']) !!}
                                                        <span class="ml-1">{{trans('fi.installments')}}</span>
                                                    </div>

                                                    <div class="card mt-2 display-none-payment-split d-none">
                                                        <div class="card-body">
                                                            <div class="payment-installments"></div>
                                                            <div class="d-none payment-installments-demo">
                                                                <div class="row col-12 mt-2">
                                                            <span class="mr-1">
                                                                <label class="label_replace mr-2"> replace. </label> {{trans('fi.payment')}}
                                                            </span>
                                                                    {!! Form::text('installment_percent_replace', null, ['id' => 'installment_percent_replace', 'class' => 'mw-80 col-md-1 col-3 payment-term-input form-control form-control-sm installment_percent_replace']) !!}
                                                                    <span class="ml-1 mr-1">
                                                                    <i class="fa-think fa-percent mr-1"></i>
                                                                    {{trans('fi.due')}}
                                                                </span>
                                                                    {!! Form::number('installment_due_days_replace', null, ['min'=>'0', 'id' => 'installment_due_days_replace', 'class' => 'mw-80 col-md-1 col-3 payment-term-input form-control form-control-sm installment_due_days_replace']) !!}
                                                                    <span class="ml-1">{{trans('fi.days_from_invoice_date')}}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                @if($editMode == true && isset($paymentTerm->id) && $defaultPaymentId == $paymentTerm->id)
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="col-2">
                                                    {!! Form::hidden('status', 1) !!}
                                                    <label class="mb-2">{{ trans('fi.type') }}:</label>
                                                </div>
                                            </div>
                                            <div class="form-check mb-3">
                                                {!! Form::radio('type', 0, null, ['id' => 'payment-term-zero', 'class' => 'form-check-input']) !!}
                                                <label class="form-check-label col-12 p-0" for="payment-term-zero">
                                                    <div class="row col-12">
                                                        <span class="mr-1">{{trans('fi.net_amount_due_in')}} </span>
                                                        {!! Form::number('net_due_days_0', $paymentTerm->net_due_days, ['min'=>'0', 'id' => 'net-due-days-zero', 'class' => 'mw-80 col-md-1 col-3 payment-term-input form-control form-control-sm net-due-days-zero']) !!}
                                                        <span class="ml-1"> {{trans('fi.days')}}</span>
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                <div class="col-md-12">
                                    <div class="form-group">
                                        @if($editMode && ($notEditable || $typeZero))
                                            <div class="col-10 mb-3">
                                                <span class="text-center w-100 text-danger"
                                                      style="font-size: 85%;font-style:italic;">
                                                    {{trans('fi.assigned_inv_sent_or_paid')}}
                                                    @if(isset($paymentTerm->id) && $defaultPaymentId == $paymentTerm->id)
                                                        <p class="m-0 text-left">
                                                            {!! trans('fi.default_payment_term_warn') !!}
                                                        </p>
                                                    @endif
                                                </span>
                                            </div>
                                        @endif

                                        <hr>
                                        @if($editMode == false || $defaultPaymentId != $paymentTerm->id)
                                            <p class="mb-2 text-center pulse">
                                            <span class="font-weight-light dynamic-message">
                                                {!! 'mmmmmmmmm' . trans('fi.days_add_in_current_date',['date'=> \Illuminate\Support\Carbon::now()->format('F d, Y')]) !!}
                                            </span>
                                            </p>
                                            <hr>
                                        @endif

                                    </div>
                                </div>

                                @if($editMode == false || $defaultPaymentId != $paymentTerm->id)
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="" data-toggle="tooltip"
                                                   title="{{trans('fi.description_template_tooltip')}}">
                                                {{ trans('fi.description_template_invoice') }}:
                                            </label>
                                            {!! Form::textarea('description_template', null, ['id' => 'description_template', 'class' => 'form-control form-control-sm','rows'=>6]) !!}
                                            <span class="text-secondary">{{trans('fi.tokens_allowed')}}:
                                              {!! trans('fi.description_tokens') !!}
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label data-toggle="tooltip"
                                                   title="{{trans('fi.description_template_tooltip')}}">
                                                {{ trans('fi.description_template_quote') }}:
                                            </label>
                                            {!! Form::textarea('quote_description_template', null, ['id' => 'quote_description_template', 'class' => 'form-control form-control-sm','rows'=>6]) !!}
                                            <span class="text-secondary">{{trans('fi.tokens_allowed')}}:
                                              {!! trans('fi.description_tokens_for_quote') !!}
                                            </span>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </section>
    {!! Form::close() !!}

@stop