<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\PaymentTerms\Requests;

use FI\Modules\PaymentTerms\Rule\PaymentTermRule;
use Illuminate\Foundation\Http\FormRequest;

class PaymentTermRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function prepareForValidation()
    {
        $request = $this->all();

        if (isset($request['type']) && $request['type'] == 4)
        {
            $request['down_payment_type'] = (($request['down_payment_type'] == 'fa-money-bill') ? 'flat_amount' : 'percentage');
        }
        else
        {
            $request['down_payment_type'] = '';
        }
        $this->replace($request);
    }

    public function rules()
    {
        return [
            'name'   => 'required',
            'status' => 'required|in:0,1',
            'type'   => ['required', new PaymentTermRule()],
        ];
    }
}
