<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\PaymentTerms\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PaymentTermEditableRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function attributes()
    {
        return [
            'name' => trans('fi.name')
        ];
    }

    public function rules()
    {
        return [
            'name' => 'required',
        ];
    }
}
