<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Office365\Controllers;

use FI\Http\Controllers\Controller;
use FI\Modules\Settings\Models\Setting;
use Illuminate\Http\Request;

/**
 * Class Office365Controller
 * @package FI\Modules\Office365\Support
 */
class Office365Controller extends Controller
{
    public function redirectToProvider()
    {
        $url = 'https://login.microsoftonline.com/' . config('services.microsoft_graph.tenant_id') . '/oauth2/v2.0/authorize' .
               '?client_id=' . config('services.microsoft_graph.client_id') .
               '&response_type=code' .
               '&redirect_uri=' . urlencode(config('services.microsoft_graph.redirect_uri')) .
               '&response_mode=query' .
               '&prompt=login' .
               '&scope=' . urlencode(config('services.microsoft_graph.scopes'));

        return redirect()->away($url);
    }

    public function handleProviderCallback(Request $request)
    {
        $authCode = $request->query('code');
        $token    = $this->getAccessToken($authCode);
        Setting::saveByKey('microsoft_365_token', $token);

        return http_response_code(200);
    }

    private function getAccessToken($code)
    {
        $url = 'https://login.microsoftonline.com/' . config('services.microsoft_graph.tenant_id') . '/oauth2/v2.0/token';

        $data = [
            'client_id'     => config('services.microsoft_graph.client_id'),
            'client_secret' => config('services.microsoft_graph.client_secret'),
            'scope'         => config('services.microsoft_graph.scopes'),
            'redirect_uri'  => config('services.microsoft_graph.redirect_uri'),
            'grant_type'    => 'authorization_code',
            'code'          => $code,
        ];

        $options = [
            'http' => [
                'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                'method'  => 'POST',
                'content' => http_build_query($data),
            ],
        ];

        $context       = stream_context_create($options);
        $response      = file_get_contents($url, false, $context);
        $response_data = json_decode($response, true);

        return $response_data['access_token'];
    }

}