@extends('client_center.layouts.public')
@include('layouts._alertifyjs')
@section('javascript')
    <script type="text/javascript">
        $(function () {
            $('#card-loader').removeClass('d-none').addClass('d-block');

            $('#card-button-cancel').click(function () {
                window.location.replace('{{route('merchant.pay.quote.square.cancel',[$quoteToken])}}');
            });

        });
    </script>
@stop

@section('content')
    @if($environment == 'sandbox')
        <script type="text/javascript" src="https://sandbox.web.squarecdn.com/v1/square.js"></script>
    @else
        <script type="text/javascript" src="https://web.squarecdn.com/v1/square.js"></script>
    @endif
    <script type="text/javascript">

        function checkForCardContainerClass()
        {
            const cardContainer = $('#card-container .sq-card-wrapper');

            if (cardContainer.length === 0)
            {
                $('#card-loader').removeClass('d-none').addClass('d-block');
            }
            else
            {
                $('#card-loader').removeClass('d-block').addClass('d-none');
            }
        }

        checkForCardContainerClass();

        setInterval(checkForCardContainerClass, 1000);

        const appId = '{{$appId}}';

        async function initializeCard(payments)
        {
            const card = await payments.card();
            await card.attach('#card-container');
            return card;
        }

        async function createPayment(token)
        {
            const body = JSON.stringify({
                sourceId: token,
            });

            const paymentResponse = await fetch('{{route('merchant.pay.quote.square.return',[$quoteToken])}}', {
                method: 'POST',
                headers: {
                    'Accept': 'application/json',
                    'Content-Type': 'application/json',
                },
                body,
            });

            return await paymentResponse.json();

        }

        async function tokenize(paymentMethod)
        {
            const tokenResult = await paymentMethod.tokenize();
            if (tokenResult.status === 'OK')
            {
                return tokenResult.token;
            }
            else
            {
                let errorMessage = '';
                if (tokenResult.errors)
                {
                    errorMessage += `${JSON.stringify(
                        tokenResult.errors
                    )}`;
                }
                throw new Error(errorMessage);
            }
        }

        // status is either SUCCESS or FAILURE;
        function displayPaymentResults(status)
        {
            const statusContainer = document.getElementById(
                'payment-status-container'
            );
            if (status === 'SUCCESS')
            {
                statusContainer.classList.remove('is-failure');
                statusContainer.classList.add('is-success');
            }
            else
            {
                statusContainer.classList.remove('is-success');
                statusContainer.classList.add('is-failure');
            }

            statusContainer.style.visibility = 'visible';
        }

        document.addEventListener('DOMContentLoaded', async function () {
            if (!window.Square)
            {
                throw new Error('Square.js failed to load properly');
            }

            let payments;
            try
            {
                payments = window.Square.payments(appId);
            }
            catch (e)
            {
                alertify.error(e.message, 10);
                setInterval(function () {
                    window.location.replace('{{route('merchant.pay.quote.square.cancel',[$quoteToken])}}');
                }, 5000);
                return;
            }

            let card;
            try
            {
                card = await initializeCard(payments);
            }
            catch (e)
            {
                alertify.error(e.message, 10);
                return;
            }

            async function handlePaymentMethodSubmission(event, paymentMethod)
            {
                event.preventDefault();
                showHideLoaderModal();
                try
                {
                    cardButton.disabled = true;
                    const token = await tokenize(paymentMethod);
                    const paymentResults = await createPayment(token);
                    const url = paymentResults.redirectUrl;
                    if (paymentResults.success == true)
                    {
                        alertify.success(paymentResults.message, 10);
                        showHideLoaderModal();
                        window.location.replace(url);
                        displayPaymentResults('SUCCESS');
                    }
                    else
                    {
                        alertify.error(paymentResults.message, 10);
                        setInterval(function () {
                            window.location.replace(url);
                        }, 5000);
                    }
                }
                catch (e)
                {
                    cardButton.disabled = false;
                    var messages = JSON.parse(e.message);
                    $.each(messages, function (id, error) {
                        alertify.error(error.message, 10);
                    });
                    displayPaymentResults('FAILURE');
                    showHideLoaderModal();
                }
            }

            const cardButton = document.getElementById('card-button');
            cardButton.addEventListener('click', async function (event) {
                await handlePaymentMethodSubmission(event, card);
            });
        });
    </script>

    <section class="content iframe-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="offset-md-4 col-md-4">
                        <div class="card card-primary card-outline mt-2">
                            <div class="card-body">
                                <div class="text-center mb-5">
                                    <img src="{{asset('assets/dist/img/square.png')}}" width="100">
                                </div>

                                <form id="payment-form">
                                    <div id="card-container" class=" mb-2">
                                        <div id="card-loader" class="text-center d-none">
                                            <div class="spinner-border" role="status">
                                                <span class="sr-only">Loading...</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div>
                                        <button class="btn btn-sm btn-outline-success btn-lightblue-shadow float-right" id="card-button"
                                                type="button">
                                            Pay {{$payableAmount}}</button>
                                        <button type="button" class="btn btn-sm btn-outline-secondary mr-1 float-right"
                                                id="card-button-cancel" data-dismiss="modal">Cancel
                                        </button>
                                    </div>
                                </form>
                                <div id="payment-status-container"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@stop