<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\MerchantQuote\Controllers;

use FI\Http\Controllers\Controller;
use FI\Modules\MerchantQuote\Support\Drivers\SquareDriver;
use FI\Modules\Quotes\Models\Quote;

class SquareController extends Controller
{
    private $driver;

    public function __construct(SquareDriver $driver)
    {
        $this->driver = $driver;
    }

    public function pay($urlKey)
    {
        $quote = Quote::where('url_key', $urlKey)->first();

        if ($quote)
        {
            if ($quote->status == 'rejected')
            {
                return redirect()->back()->with('error', trans('fi.quote_rejected_not_payable', ['number' => $quote->number]));
            }
            elseif ($quote->amount->total == 0 && $quote->status == 'canceled')
            {
                return redirect()->back()->with('error', trans('fi.quote_add_items'));
            }
            else
            {
                return $this->driver->pay($quote);
            }
        }
        else
        {
            return redirect('/')->with('error', trans('fi.invalid_quote_id'));
        }

    }

    public function success($urlKey)
    {
        $quote = Quote::where('url_key', $urlKey)->first();

        if ($quote)
        {
            return $this->driver->success($quote, request('sourceId'));
        }
        else
        {
            return redirect('/')->with('error', trans('fi.invalid_quote_id'));
        }
    }

    public function cancel($urlKey)
    {
        $quote = Quote::where('url_key', $urlKey)->first();

        if ($quote)
        {
            return $this->driver->cancel($urlKey, $quote->token);
        }
        else
        {
            return redirect('/')->with('error', trans('fi.invalid_quote_id'));
        }
    }
}