<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Merchant\Controllers;

use FI\Http\Controllers\Controller;
use FI\Modules\Invoices\Models\Invoice;
use FI\Modules\Merchant\Support\Drivers\MollieDriver;
use FI\Modules\Quotes\Models\Quote;

class MollieController extends Controller
{
    private $driver;

    public function __construct(MollieDriver $driver)
    {
        $this->driver = $driver;
    }

    public function pay($urlKey, $modal, $quoteUrlKey = '')
    {
        $invoice = Invoice::where('url_key', $urlKey)->first();
        if ($invoice->amount->balance == 0 && $invoice->amount->total > 0 && $invoice->status != 'canceled')
        {
            return redirect()->back()->with('error', trans('fi.invoice_already_paid'));
        }
        else
        {
            return redirect($this->driver->pay($invoice, $modal, $quoteUrlKey));
        }
    }

    public function success($urlKey, $modal, $quoteUrlKey = '')
    {
        if ($quoteUrlKey != '')
        {
            if ($modal == 'pi' && class_exists(\Addons\ProformaInvoice\Models\ProformaInvoice::class) && config('proforma_invoice_enabled') == true)
            {
                $proformaInvoice = \Addons\ProformaInvoice\Models\ProformaInvoice::where('url_key', $quoteUrlKey)->first();
                $proformaInvoice->invoice->delete();
                return redirect()->route('clientCenter.public.proformaInvoice.show', [$quoteUrlKey, $proformaInvoice->token]);
            }
            else
            {
                $quote = Quote::where('url_key', $quoteUrlKey)->first();
                $quote->invoice->delete();
                return redirect()->route('clientCenter.public.quote.show', [$quoteUrlKey, $quote->token]);
            }
        }

        $invoice = Invoice::where('url_key', $urlKey)->first();

        return redirect()->route('clientCenter.public.invoice.show', [$urlKey, $invoice->token]);
    }

    public function webhook($urlKey, $modal, $quoteUrlKey = '')
    {
        $invoice = Invoice::where('url_key', $urlKey)->first();
        $this->driver->verify($invoice, $modal, $quoteUrlKey);

        http_response_code(200);

        exit;
    }
}