<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Exports\Support\Results;

use FI\Modules\Clients\Models\Client;
use FI\Modules\CustomFields\Support\CustomFieldsParser;
use Illuminate\Support\Facades\DB;

class Clients implements SourceInterface
{
    public function getResults($params = [])
    {
        $customFields = CustomFieldsParser::getFields('clients');
        $client       = Client::orderBy('name')
            ->select('clients.*', DB::raw("GROUP_CONCAT(tags.name) as client_tags"))
            ->leftJoin('clients_custom', 'clients.id', '=', 'clients_custom.client_id')
            ->leftJoin('client_tags', 'clients.id', '=', 'client_tags.client_id')
            ->leftJoin('tags', 'client_tags.tag_id', '=', 'tags.id');

        foreach ($customFields as $customField)
        {
            $client->addSelect("clients_custom." . $customField->column_name . " AS " . $customField->field_label);
        }

        return $client->groupBy('clients.id')->get()->toArray();
    }
}