<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Expenses\Requests;

use FI\Requests\RemoveTagsRule;
use Illuminate\Foundation\Http\FormRequest;

class ExpenseVendorRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function attributes()
    {
        return [
            'name'  => trans('fi.vendor'),
            'email' => trans('fi.email'),
        ];
    }

    public function rules()
    {
        if ($this->route('id'))
        {
            return [
                'name'          => 'required|max:255|unique:expense_vendors,name,' . $this->route('id'),
                'email'         => 'email',
                'mobile'        => [new RemoveTagsRule],
                'contact_names' => [new RemoveTagsRule],
                'notes'         => [new RemoveTagsRule],
                'address'       => [new RemoveTagsRule],
            ];
        }
        else
        {
            return [
                'name'          => 'required|max:255|unique:expense_vendors,name',
                'email'         => 'email',
                'mobile'        => [new RemoveTagsRule],
                'contact_names' => [new RemoveTagsRule],
                'notes'         => [new RemoveTagsRule],
                'address'       => [new RemoveTagsRule],
            ];
        }
    }
}