<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Expenses\Models;

use FI\Modules\Expenses\Events\AddTransitionVendor;
use Illuminate\Support\Facades\Cache;

class ExpenseVendorObserver
{
    public function created(ExpenseVendor $expenseVendor)
    {
        Cache::forget('getListExpenseVendorCache');
        Cache::forget('getDropDownListExpenseVendorCache');
        event(new AddTransitionVendor($expenseVendor, 'created'));
    }

    public function updated(ExpenseVendor $expenseVendor)
    {
        Cache::forget('getListExpenseVendorCache');
        Cache::forget('getDropDownListExpenseVendorCache');
        event(new AddTransitionVendor($expenseVendor, 'updated'));
    }

    public function deleted(ExpenseVendor $expenseVendor)
    {
        Cache::forget('getListExpenseVendorCache');
        Cache::forget('getDropDownListExpenseVendorCache');
        Expense::where('vendor_id', $expenseVendor->id)->update(['vendor_id' => 0]);
    }
}