<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Expenses\Models;

use Illuminate\Support\Facades\Cache;

class ExpenseCategoryObserver
{
    public function created(ExpenseCategory $expenseCategory)
    {
        Cache::forget('getListExpenseCategoryCache');
        Cache::forget('getDropDownListExpenseCategoryCache');
        Cache::forget('getCategoryListExpenseCategoryCache');
    }

    public function updated(ExpenseCategory $expenseCategory)
    {
        Cache::forget('getListExpenseCategoryCache');
        Cache::forget('getDropDownListExpenseCategoryCache');
        Cache::forget('getCategoryListExpenseCategoryCache');
    }

    public function deleted(ExpenseCategory $expenseCategory)
    {
        Cache::forget('getListExpenseCategoryCache');
        Cache::forget('getDropDownListExpenseCategoryCache');
        Cache::forget('getCategoryListExpenseCategoryCache');
        Expense::where('category_id', $expenseCategory->id)->update(['category_id' => 0]);
    }
}