<script type="text/javascript">

    $(function () {

        $('#default-mail-template').modal();

        $('.default-mail-template-confirm').click(function () {
            $.post('{{route('settings.reset.mail.template')}}', {
                actionType: '{{$actionType}}',
                modelTemplateName: '{{$modelTemplateName}}'
            }).done(function (response) {
                alertify.success(response.message, 5);
                $('#default-mail-template').modal('hide');
                setTimeout(function () {
                    window.location = "{{ route('settings.index') }}"
                }, 3000);
            }).fail(function (response) {
                alertify.error($.parseJSON(response.responseText).message, 5);
                $('#default-mail-template').modal('hide');
            })
        });
    });
</script>
<div class="modal fade" id="default-mail-template" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger">
                <h5 class="modal-title">{{ trans('fi.delete-confirm') }}</h5>
                <button type="button" class="close default-mail-template-close" data-dismiss="modal" aria-hidden="true">
                    &times;
                </button>
            </div>
            <div class="modal-body">
                {!! trans('fi.reset_to_default_warning',['model'=> $modelTemplateName]) !!}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-sm btn-outline-secondary default-mail-template-close"
                        data-dismiss="modal">{{ trans('fi.no') }}</button>
                <button type="button" id="default-mail-template-confirm"
                        class="btn btn-sm btn-outline-danger default-mail-template-confirm">{{ trans('fi.yes') }}</button>
            </div>
        </div>
    </div>
</div>