<script type="text/javascript">
    $(function () {

        $('body #modal-view-revision').modal();

        ajaxGetStartAndEndDates();

        function ajaxGetStartAndEndDates()
        {
            $.post('{{route('recurring.invoice.get.service.dates')}}',
                {
                    next_date: '{{$ri['formatted_next_date']}}',
                    recurring_frequency: '{{$ri['recurring_frequency']}}',
                    recurring_period: '{{$ri['recurring_period']}}',
                    service_starts_on: '{{$ri['service_starts_on']}}',
                    service_ends_of_the: '{{$ri['service_ends_of_the']}}',
                }).done(function (responce) {
                $('#service-starts-ri').text(responce.service_start_date);
                $('#service-ends-ri').text(responce.service_end_date);
            }).fail(function (response) {
                alertify.error($.parseJSON(response.responseText).message, 5);
            });
        }

    });
</script>
<style>
    .revision-scroller::-webkit-scrollbar {
        height: 6px;
        width: 6px;
        cursor: e-resize;
    }

    .revision-scroller::-webkit-scrollbar-thumb {
        border-radius: 10px;
        background-color: #fff;
        -webkit-box-shadow: inset 0 0 6px rgb(206 212 218);
    }

    .font-weight-custom {
        font-size: .875rem !important;
    }

    @media only screen and (max-width: 600px) {
        .revision-doc-watermark {
            left: 50px;
        }
    }

</style>
<div class="modal fade" id="modal-view-revision" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog text-break modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fa fa-history" aria-hidden="true"></i>
                    <span>  @if($revisionDoc->revision_number == 1)
                            {{ trans('fi.original') }}
                        @else
                            {{ trans('fi.revision') }} #{{$revisionDoc->revision_number - 1}}
                        @endif
                        <span class="badge">
                            <span class="badge badge-light">{{ $revisionDoc->formatted_created_at }}</span>
                            <span class="badge badge-light">#{{$ri['number']}}</span>
                        </span>
                    </span>
                </h5>
                <button type="button" class="close close-hide" data-dismiss="modal" aria-hidden="true">&times;</button>
            </div>
            <div class="modal-body small revision-scroller overflow-auto text-nowrap" style="calc(100vh - 100px);">
                <section class="content-header p-0">
                    <div class="container-fluid">
                        <div class="revision-doc-watermark"
                             style="top: 35% !important;">
                            @if($revisionDoc->revision_number > 1)
                                {{ trans('fi.revision') }}
                            @else
                                {{ trans('fi.original') }}
                            @endif
                        </div>
                    </div>
                </section>
                <section class="content">
                    <div class="container-fluid">
                        <div class="row">

                            <div class="col-lg-10">
                                <div id="form-status-placeholder"></div>

                                <div class="card card-info card-outline">
                                    <!-- /.card-header -->
                                    <div class="card-body font-weight-custom pt-2 pb-2">
                                        <div class="row">

                                            <div class="col-md-3 text-wrap">
                                                <div class="form-group m-0">
                                                    <label>{{ trans('fi.frequency') }}</label>
                                                    <br>
                                                    <p class="font-weight-custom mb-1">
                                                        {{$ri['recurring_frequency']}}
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="col-md-4 text-wrap">
                                                <div class="form-group m-0">
                                                    <label>{{ trans('fi.every') }}</label>
                                                    <br>
                                                    <p class="font-weight-custom mb-1">
                                                        {{$ri['recurring_period']}}
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="col-md-3 text-wrap">
                                                <div class="form-group m-0">
                                                    <label>{{ trans('fi.generate_next_invoice') }}</label>
                                                    <br>
                                                    <p class="font-weight-custom mb-1">
                                                        {{$ri['formatted_next_date']}}
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="col-md-2 text-wrap">
                                                <div class="form-group m-0">
                                                    <label>{{ trans('fi.stop_date') }}</label>
                                                    <br>
                                                    <p class="font-weight-custom mb-1">
                                                        {{$ri['formatted_stop_date']}}
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /.card-body -->
                                </div>

                                <div class="card card-info card-outline">
                                    <div class="card-header">
                                        <h3 class="card-title">{{ trans('fi.subscription') }}</h3>
                                    </div>
                                    <div class="card-body font-weight-custom pt-2 pb-2 text-wrap">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <div class="input-group">
                                                    <label data-toggle="tooltip" data-placement="auto" title=""
                                                           data-original-title="{{trans('fi.tt_explanation')}}">
                                                        {{ trans('fi.explanation') }}
                                                    </label>
                                                    <div class="input-group">
                                                        <span class="form-control form-control-sm">{{$ri['service_explanation']}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="input-group">
                                                    <label class="mr-1">{{ trans('fi.service_starts') }} </label>
                                                    <span class="font-weight-light"> {{trans('fi.on')}} </span>
                                                    <div class="input-group">
                                                        <span class="form-control form-control-sm">{{$ri['service_starts_on']}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="input-group">
                                                    <label class="mr-1">{{ trans('fi.service_starts') }} </label>
                                                    <span class="font-weight-light">  {{trans('fi.of_the')}}</span>
                                                    <div class="input-group">
                                                        <span class="form-control form-control-sm">{{$ri['service_ends_of_the']}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="card card-info card-outline">
                                    <!-- /.card-header -->
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-8 text-wrap">
                                                <div class="form-group m-0">
                                                    <label class="m-0">
                                                        <div class="card-header pb-1 pl-0">
                                                            <h3 class="card-title">{{ trans('fi.summary') }}</h3>
                                                        </div>
                                                        <p class="font-weight-custom mb-1">
                                                            {{$ri['summary']}}
                                                        </p>
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="col-md-4 text-wrap">
                                                <div class="form-group m-0">

                                                    <label class="m-0">

                                                        <div class="card-header pb-1 pl-0">
                                                            <h3 class="card-title">{{ trans('fi.tags') }}</h3>
                                                        </div>
                                                        <p class="mb-1">
                                                            @foreach($ri['selected_tags'] as $tag)
                                                                <span class="badge badge-default">{{$tag}}</span>
                                                            @endforeach
                                                        </p>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /.row -->
                                    </div>
                                    <!-- /.card-body -->
                                </div>

                                <div class="row">

                                    <div class="col-sm-6" id="col-from">

                                        <div class="card card-info card-outline">
                                            <div class="card-header">
                                                <h3 class="card-title">{{ trans('fi.from') }}</h3>
                                            </div>
                                            <div class="card-body font-weight-custom text-wrap pt-2 pb-2">
                                                <strong>{{ $ri['company'] }}</strong><br>
                                                {!! $ri['company_address'] !!}<br>
                                                {{ trans('fi.phone') }}: {{ $ri['company_phone'] }}<br>
                                                {{ trans('fi.email') }}
                                                : {{ isset($ri['user_from_email']) ? $ri['user_from_email'] : '' }}
                                            </div>
                                        </div>

                                    </div>

                                    <div class="col-sm-6" id="col-to">


                                        <div class="card card-info card-outline">
                                            <div class="card-header">
                                                <h3 class="card-title">{{ trans('fi.to') }}</h3>
                                            </div>
                                            <div class="card-body font-weight-custom pt-2 pb-2 text-wrap">
                                                <strong>{{ $ri['client_name'] }}</strong><br>

                                                {!! $ri['client_formatted_address'] !!}<br>
                                                {{ trans('fi.phone') }}: {{ $ri['client_phone'] }}<br>
                                                {{ trans('fi.email') }}: {{ $ri['client_email'] }}
                                            </div>
                                        </div>

                                    </div>

                                </div>

                                <div class="row">

                                    <div class="col-sm-12 table-responsive" style="overflow-x: visible;">
                                        <div class="card card-info card-outline">
                                            <div class="card-header">
                                                <h3 class="card-title">{{ trans('fi.items') }}</h3>
                                            </div>

                                            <div class="card-body text-wrap pt-2 pb-2 table-responsive font-weight-custom">
                                                <table class="table table-hover table-striped table-sm text-nowrap">
                                                    <thead>
                                                    <tr>
                                                        <th></th>
                                                        <th>{{ trans('fi.product') }}
                                                            / {{ trans('fi.description') }}</th>
                                                        <th>{{ trans('fi.qty') }}</th>
                                                        <th>{{ trans('fi.price') }}</th>
                                                        <th>{{ trans('fi.tax_1') }}
                                                            @if(config('fi.numberOfTaxFields') == '2')
                                                                / {{ trans('fi.tax_2') }}
                                                            @endif
                                                        </th>
                                                        <th class="text-right">{{ trans('fi.total') }}</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @foreach ($ri['items'] as $key =>  $item)

                                                        <tr>
                                                            <td><i class="fa fa-circle small"
                                                                   style=" font-size: 10px;"> </i></td>
                                                            <td>
                                                                {{$item['name']}}
                                                                <br>
                                                                {{$item['description']}}
                                                            </td>
                                                            <td class="text-center">{{$item['quantity']}}</td>
                                                            <td class="text-center">{{$item['numeric_price']}}</td>
                                                            <td class="text-center">
                                                                <p class="m-0 ">{{ $item['tax_rate_id'] }}</p>@if(config('fi.numberOfTaxFields') == '2')
                                                                    <p class="m-0 ">{{ $item['tax_rate_2_id'] }}</p>
                                                                @endif
                                                            </td>
                                                            <td class="text-right ">{{ $item['item_subtotal'] }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td></td>
                                                            <td colspan="5">
                                                                @if (isset($item['custom']) && count($item['custom']) > 0)
                                                                    @foreach (array_chunk($item['custom'], 3) as $customFieldsChunk)
                                                                        <div class="row">
                                                                            @foreach($customFieldsChunk as $customField)
                                                                                @foreach($customField as $key => $value)
                                                                                    <div class="col-md-4">
                                                                                        <div class="form-group">
                                                                                            <label>{{ $key }}
                                                                                                :</label>
                                                                                            <span>{{ $value }}:</span>
                                                                                        </div>
                                                                                    </div>
                                                                                @endforeach
                                                                            @endforeach
                                                                        </div>
                                                                    @endforeach
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">

                                    <div class="col-12">
                                        <div class="card card-info card-outline card-outline-tabs">

                                            <div class="card-header p-0 border-bottom-0">
                                                <ul class="nav nav-tabs">
                                                    <li class="nav-item">
                                                        <a href="#tab-additional-ri" class="nav-link  active"
                                                           data-toggle="tab">{{ trans('fi.additional') }}</a>
                                                    </li>
                                                    @if ($ri['custom'] && count($ri['custom']) > 0)
                                                        <li class="nav-item">
                                                            <a href="#tab-custom-ri" class="nav-link"
                                                               data-toggle="tab">
                                                                {{ trans('fi.custom_fields') }}
                                                            </a>
                                                        </li>
                                                    @endif

                                                </ul>
                                            </div>
                                            <div class="card-body text-wrap font-weight-custom pt-2 pb-2">
                                                <div class="tab-content">

                                                    <div class="tab-pane active" id="tab-additional-ri">
                                                        <div class="row">
                                                            <div class="col-lg-6">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.terms_and_conditions') }}</label>
                                                                    {!! Form::textarea('terms', $ri['terms'], ['class' => 'form-control form-control-sm', 'rows' => 3,'disabled']) !!}
                                                                </div>
                                                            </div>

                                                            <div class="col-lg-6">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.footer') }}</label>
                                                                    {!! Form::textarea('footer', $ri['footer'], [ 'class' => 'form-control form-control-sm', 'rows' => 3,'disabled']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @if ($ri['custom'] && count($ri['custom']) > 0)
                                                        <div class="tab-pane" id="tab-custom-ri">
                                                            <div class="row">
                                                                @foreach ($ri['custom'] as $key => $customField)
                                                                    @foreach($customField as $key => $value)
                                                                        <div class="col-md-12">
                                                                            <div class="form-group">
                                                                                <label>{{ $key }}:</label>
                                                                                <span>{{ $value }}</span>
                                                                            </div>
                                                                        </div>
                                                                    @endforeach
                                                                @endforeach
                                                            </div>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-2">

                                <div id="div-totals">
                                    <div class="card card-info card-outline">
                                        <div class="card-body mb-1">
                                            <span class="float-left"><strong>{{ trans('fi.subtotal') }}</strong></span><span
                                                    class="float-right">{{ $ri['subtotal'] }}</span>

                                            <div class="clearfix"></div>

                                            @if ($ri['discount'] > 0)
                                                <span class="float-left"><strong>{{ trans('fi.discount') }}</strong></span>
                                                <span
                                                        class="float-right">{{ $ri['formatted_discount']  }}</span>

                                                <div class="clearfix"></div>
                                            @endif

                                            <span class="float-left"><strong>{{ trans('fi.tax') }}</strong></span><span
                                                    class="float-right">{{ $ri['tax'] }}</span>

                                            <div class="clearfix"></div>
                                            <span class="float-left"><strong>{{ trans('fi.total') }}</strong></span><span
                                                    class="float-right">{{ $ri['total'] }}</span>

                                            <div class="clearfix"></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="card card-info card-outline">

                                    <div class="card-header">
                                        <h3 class="card-title">{{ trans('fi.options') }}</h3>
                                    </div>

                                    <div class="card-body">

                                        <div class="form-group">
                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.service_starts') }}</label>
                                                <p class="m-0">
                                                    <span id="service-starts-ri"></span>

                                                </p>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.service_ends') }}</label>
                                                <p class="m-0">
                                                    <span id="service-ends-ri"></span>
                                                </p>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="document-options-label">{{ trans('fi.discount') }}</label>
                                            <p class="m-0">
                                                @if($ri['discount_type'] == '')
                                                    <i class="fa fa-ban text-center"> </i>
                                                @elseif($ri['discount_type'] == 'percentage')
                                                    {{ $ri['numeric_discount'] }}
                                                    <i class="fa fa-percentage pr-2"> </i>
                                                @elseif($ri['discount_type'] == 'flat_amount')
                                                    {{ $ri['numeric_discount'] }}
                                                    <i class="fa fa-money-bill pr-2"> </i>
                                                @endif
                                            </p>
                                        </div>

                                        <div class="form-group">
                                            <label class="document-options-label">{{ trans('fi.currency') }}</label>
                                            <p class="m-0">
                                                {{$ri['currency_code']}}
                                            </p>
                                        </div>

                                        <div class="form-group">
                                            <label class="document-options-label">{{ trans('fi.exchange_rate') }}</label>
                                            <p class="m-0">
                                                {{$ri['exchange_rate']}}
                                            </p>
                                        </div>
                                        <div class="form-group">
                                            <label class="document-options-label">{{ trans('fi.document_number_schemes') }}</label>
                                            <p class="m-0">
                                                {{$ri['document_number_scheme']}}
                                            </p>
                                        </div>

                                        <div class="form-group">
                                            <label class="document-options-label">{{ trans('fi.template') }}</label>
                                            <p class="m-0">{{$ri['template']}}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </section>
            </div>

            <div class="modal-footer pb-1 pt-1">
                <div class="col-sm-12">
                    <button type="button" class="btn btn-sm btn-outline-secondary float-right close-hide"
                            data-dismiss="modal"
                            id="btn-clear-column-filter">
                        {{ trans('fi.cancel') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>