<script type="text/javascript">
    $(function () {
        $('body #modal-view-revision').modal();
    });
</script>
<style>
    .revision-scroller::-webkit-scrollbar {
        height: 6px;
        width: 6px;
        cursor: e-resize;
    }

    .revision-scroller::-webkit-scrollbar-thumb {
        border-radius: 10px;
        background-color: #fff;
        -webkit-box-shadow: inset 0 0 6px rgb(206 212 218);
    }

    .font-weight-custom {
        font-size: .875rem !important;
    }

    @media only screen and (max-width: 600px) {
        .revision-doc-watermark {
            left: 50px;
        }
    }

</style>
<div class="modal fade" id="modal-view-revision" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog text-break modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fa fa-history" aria-hidden="true"></i>
                    <span>
                         @if($revisionDoc->revision_number == 1)
                            {{ trans('fi.original') }}
                        @else
                            {{ trans('fi.revision') }} #{{$revisionDoc->revision_number - 1}}
                        @endif
                        <span class="badge">
                            <span class="badge badge-light">{{ $revisionDoc->formatted_created_at }}</span>
                            <span class="badge badge-light">#{{$quote['number']}}</span>
                            @if ($quote['viewed'])
                                <span class="badge badge-success">{{ trans('fi.viewed') }}</span>
                            @endif
                            <span class="badge badge-{{$quote['status']}}">{{ trans('fi.'.$quote['status']) }}</span>

                            @if ($quote['is_invoice'])
                                <span class="badge badge-info">
                                    <a href="{{ route('invoices.edit', [$quote['invoice_id']]) }}"
                                       style="color: inherit;">{{ trans('fi.converted_to_invoice') }} {{ $quote['invoice_number'] }}</a>
                                </span>
                            @endif
                        </span>
                    </span>
                </h5>
                <button type="button" class="close close-hide" data-dismiss="modal" aria-hidden="true">&times;</button>
            </div>
            <div class="modal-body small revision-scroller overflow-auto text-nowrap" style="calc(100vh - 100px);">
                <section class="content-header p-0">
                    <div class="container-fluid">
                        <div class="revision-doc-watermark"
                             style="top: 35% !important;">
                            @if($revisionDoc->revision_number > 1)
                                {{ trans('fi.revision') }}
                            @else
                                {{ trans('fi.original') }}
                            @endif
                        </div>
                    </div>
                </section>
                <section class="content">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-lg-10">
                                <div id="form-status-placeholder"></div>
                                <div class="card card-info card-outline">
                                    <div class="card-body font-weight-custom pt-2 pb-2">
                                        <div class="row">
                                            <div class="col-md-8 text-wrap">
                                                <div class="form-group m-0">
                                                    <label class="m-0">
                                                        <div class="card-header pb-1 pl-0">
                                                            <h3 class="card-title">{{ trans('fi.summary') }}</h3>
                                                        </div>
                                                        <p class="font-weight-custom mb-1">
                                                            {{$quote['summary']}}
                                                        </p>
                                                    </label>
                                                </div>
                                            </div>

                                            <!-- /.col -->
                                            <div class="col-md-4 text-wrap">
                                                <div class="form-group m-0">

                                                    <label class="m-0">

                                                        <div class="card-header pb-1 pl-0">
                                                            <h3 class="card-title">{{ trans('fi.tags') }}</h3>
                                                        </div>
                                                        <p class="mb-1">
                                                            @foreach($quote['selected_tags'] as $tag)
                                                                <span class="badge badge-default">{{$tag}}</span>
                                                            @endforeach
                                                        </p>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">

                                    <div class="col-sm-6" id="col-from">


                                        <div class="card card-info card-outline">
                                            <div class="card-header">
                                                <h3 class="card-title">{{ trans('fi.from') }}</h3>
                                            </div>
                                            <div class="card-body font-weight-custom text-wrap pt-2 pb-2">
                                                <strong>{{ $quote['company'] }}</strong><br>
                                                {!! $quote['company_address'] !!}<br>
                                                {{ trans('fi.phone') }}: {{ $quote['company_phone'] }}<br>
                                                @if(isset($quote['user_from_email']) && $quote['user_from_email'] != null)
                                                    {{ trans('fi.email') }} : {{ $quote['user_from_email'] }}
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6" id="col-to">
                                        <div class="card card-info card-outline">
                                            <div class="card-header">
                                                <h3 class="card-title">{{ trans('fi.to') }}</h3>
                                            </div>
                                            <div class="card-body font-weight-custom pt-2 pb-2 text-wrap">
                                                <strong>{{ $quote['client_name'] }}</strong><br>

                                                {!! $quote['client_formatted_address'] !!}<br>
                                                {{ trans('fi.phone') }}: {{ $quote['client_phone'] }}<br>
                                                {{ trans('fi.email') }}: {{ $quote['client_email'] }}
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-sm-12" style="overflow-x: visible;">
                                        <div class="card card-info card-outline">
                                            <div class="card-header">
                                                <h3 class="card-title">{{ trans('fi.items') }}</h3>
                                            </div>
                                            <div class="card-body text-wrap pt-2 pb-2 table-responsive font-weight-custom">
                                                <table class="table table-hover table-striped table-sm text-nowrap">
                                                    <thead>
                                                    <tr>
                                                        <th></th>
                                                        <th> {{ trans('fi.product') }}
                                                            / {{ trans('fi.description') }}</th>
                                                        <th>{{ trans('fi.qty') }}</th>
                                                        <th>{{ trans('fi.price') }}</th>
                                                        @if($quote['allow_line_item_discounts'] == true)
                                                            <th class="text-center">{{ trans('fi.discount') }}</th>
                                                        @endif
                                                        <th class="text-center">
                                                            {{ trans('fi.tax_1') }} @if(config('fi.numberOfTaxFields') == '2')
                                                                / {{ trans('fi.tax_2') }}
                                                            @endif
                                                        </th>
                                                        <th class="text-right">{{ trans('fi.total') }}</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @foreach ($quote['items'] as $key =>  $item)

                                                        <tr>
                                                            <td><i class="fa fa-circle small"
                                                                   style=" font-size: 10px;"> </i></td>
                                                            <td>
                                                                {{$item['name']}}
                                                                <br>
                                                                {{$item['description']}}
                                                            </td>
                                                            <td class="text-center">{{$item['quantity']}}</td>
                                                            <td class="text-center">{{$item['numeric_price']}}</td>
                                                            @if($quote['allow_line_item_discounts'] == true)
                                                                <td class="text-center">
                                                                    @if($item['discount_type'] == '')
                                                                        <i class="fa fa-ban"></i>
                                                                    @elseif($item['discount_type'] == 'percentage')
                                                                        {{$item['numeric_discount']}}
                                                                        <i class="fa fa-percentage"></i>
                                                                    @elseif($item['discount_type'] == 'flat_amount')
                                                                        {{$item['numeric_discount']}}
                                                                        <i class="fa fa-money-bill"></i>
                                                                    @endif
                                                                </td>
                                                            @endif
                                                            <td class="text-center">
                                                                <p class="m-0 ">{{ $item['tax_rate_id'] }}</p>@if(config('fi.numberOfTaxFields') == '2')
                                                                    <p class="m-0 ">{{ $item['tax_rate_2_id'] }}</p>
                                                                @endif
                                                            </td>
                                                            <td class="text-right ">{{ $item['item_subtotal'] }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td></td>
                                                            <td colspan="{{ ($quote['allow_line_item_discounts'] == true) ? 6 : 5 }}">
                                                                @if (isset($item['custom']) && count($item['custom']) > 0)
                                                                    @foreach (array_chunk($item['custom'], 3) as $customFieldsChunk)
                                                                        <div class="row">
                                                                            @foreach($customFieldsChunk as $customField)
                                                                                @foreach($customField as $key => $value)
                                                                                    <div class="col-md-4">
                                                                                        <div class="form-group">
                                                                                            <label>{{ $key }}
                                                                                                :</label>
                                                                                            <span>{{ $value }}:</span>
                                                                                        </div>
                                                                                    </div>
                                                                                @endforeach
                                                                            @endforeach
                                                                        </div>
                                                                    @endforeach
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12">
                                        <div class="card card-info card-outline card-outline-tabs">
                                            <div class="card-header p-0 border-bottom-0">
                                                <ul class="nav nav-tabs">
                                                    <li class="nav-item">
                                                        <a href="#tab-additional-quote" class="nav-link  active"
                                                           data-toggle="tab">{{ trans('fi.additional') }}</a>
                                                    </li>
                                                    @if ($quote['custom'] && count($quote['custom']) > 0)
                                                        <li class="nav-item">
                                                            <a href="#tab-custom-quote" class="nav-link"
                                                               data-toggle="tab">
                                                                {{ trans('fi.custom_fields') }}
                                                            </a>
                                                        </li>
                                                    @endif
                                                </ul>
                                            </div>

                                            <div class="card-body text-wrap font-weight-custom pt-2 pb-2">
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="tab-additional-quote">
                                                        <div class="row">
                                                            <div class="col-lg-6">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.terms_and_conditions') }}</label>
                                                                    {!! Form::textarea('terms', $quote['terms'], ['id' => 'terms', 'class' => 'form-control form-control-sm', 'rows' => 3,'disabled'=>true]) !!}
                                                                </div>
                                                            </div>

                                                            <div class="col-lg-6">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.footer') }}</label>
                                                                    {!! Form::textarea('footer', $quote['footer'], ['id' => 'footer', 'class' => 'form-control form-control-sm', 'rows' => 3,'disabled'=>true]) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @if ($quote['custom'] && count($quote['custom']) > 0)
                                                        <div class="tab-pane" id="tab-custom-quote">
                                                            <div class="row">
                                                                @foreach ($quote['custom'] as $key => $customField)
                                                                    @foreach($customField as $key => $value)
                                                                        <div class="col-md-12">
                                                                            <div class="form-group">
                                                                                <label>{{ $key }}:</label>
                                                                                <span>{{ $value }}</span>
                                                                            </div>
                                                                        </div>
                                                                    @endforeach
                                                                @endforeach
                                                            </div>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-2">

                                <div id="div-totals text-wrap">
                                    <div class="card card-info card-outline">
                                        <div class="card-body font-weight-custom p-2">
                                            <span class="float-left"><strong>{{ trans('fi.subtotal') }}</strong></span>
                                            <span class="float-right">{{ $quote['subtotal'] }}</span>
                                            <div class="clearfix"></div>
                                            @if ($quote['discount'] > 0)
                                                <span class="float-left"><strong>{{ trans('fi.discount') }}</strong></span>
                                                <span class="float-right">{{ $quote['formatted_discount'] }}</span>
                                                <div class="clearfix"></div>
                                            @endif
                                            <span class="float-left"><strong>{{ trans('fi.tax') }}</strong></span>
                                            <span class="float-right">{{ $quote['tax'] }}</span>
                                            <div class="clearfix"></div>

                                            <span class="float-left"><strong>{{ trans('fi.total') }}</strong></span>
                                            <span class="float-right">{{ $quote['total'] }}</span>
                                            <div class="clearfix"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="text-wrap">
                                    <div class="card card-info card-outline">

                                        <div class="card-header">
                                            <h3 class="card-title">{{ trans('fi.options') }}</h3>
                                        </div>

                                        <div class="card-body font-weight-custom p-2">
                                            @if(isset($quote['setting_is_payable_quote']) && $quote['setting_is_payable_quote']==1)
                                                <div class="form-group">
                                                    <label class="document-options-label">
                                                        {{ trans('fi.allow_payments_on_quote') }}:
                                                    </label>
                                                    <p class="m-0">
                                                        {{yesNoArray()[$quote['is_payable_quote']]}}
                                                    </p>
                                                </div>

                                                @if(isset($quote['online_payment_processing_fee']) && isset($quote['enableOppFees']) && $quote['enableOppFees'] == true)
                                                    <div class="form-group">
                                                        <label class="document-options-label">
                                                            {{ trans('fi.allow_online_pay_fees') }}:
                                                        </label>
                                                        <p class="m-0">
                                                            {{trans('fi.'.$quote['online_payment_processing_fee'])}}
                                                        </p>
                                                    </div>
                                                @endif

                                            @endif

                                            <div class="form-group">
                                                <label class="document-options-label">
                                                    {{ trans('fi.quote') }} #
                                                </label>
                                                <p class="m-0">
                                                    {{$quote['number']}}
                                                </p>
                                            </div>
                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.date') }}</label>
                                                <p class="m-0">
                                                    {{$quote['formatted_quote_date']}}
                                                </p>
                                            </div>
                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.expires') }}</label>
                                                <p class="m-0">
                                                    {{$quote['expires_at']}}
                                                </p>
                                            </div>

                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.discount') }}</label>
                                                <p class="m-0">
                                                    @if($quote['discount_type'] == '')
                                                        <i class="fa fa-ban text-center"> </i>
                                                    @elseif($quote['discount_type'] == 'percentage')
                                                        {{ $quote['numeric_discount'] }}
                                                        <i class="fa fa-percentage pr-2"> </i>
                                                    @elseif($quote['discount_type'] == 'flat_amount')
                                                        {{ $quote['numeric_discount'] }}
                                                        <i class="fa fa-money-bill pr-2"> </i>
                                                    @endif
                                                </p>
                                            </div>

                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.currency') }}</label>
                                                <p class="m-0">
                                                    {{$quote['currency_code']}}
                                                </p>
                                            </div>

                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.exchange_rate') }}</label>
                                                <p class="m-0">
                                                    {{$quote['exchange_rate']}}
                                                </p>
                                            </div>

                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.status') }}</label>
                                                <p class="m-0">
                                                    {{$quote['status']}}
                                                </p>
                                            </div>

                                            <div class="form-group">
                                                <label class="document-options-label">{{ trans('fi.template') }}</label>
                                                <p class="m-0">{{$quote['template']}}</p>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>

            <div class="modal-footer pb-1 pt-1">
                <div class="col-sm-12">
                    <button type="button" class="btn btn-sm btn-outline-secondary float-right close-hide"
                            data-dismiss="modal"
                            id="btn-clear-column-filter">
                        {{ trans('fi.cancel') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>