<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\DocumentRevisions\Controllers;

use FI\Http\Controllers\Controller;
use FI\Modules\DocumentRevisions\Models\DocumentRevision;
use FI\Support\PDF\PDFFactory;

class DocumentRevisionController extends Controller
{
    public function viewModal()
    {
        try
        {

            $revisionDoc = DocumentRevision::whereId(request('id'))->first();

            if ($revisionDoc)
            {
                if ($revisionDoc->revisable_type == 'FI\Modules\Invoices\Models\Invoice')
                {
                    return view('document_revision._modal_invoice_view')->with('revisionDoc', $revisionDoc)->with('invoice', $revisionDoc->formatted_text);
                }
                else if ($revisionDoc->revisable_type == 'FI\Modules\Quotes\Models\Quote')
                {
                    return view('document_revision._modal_quote_view')->with('revisionDoc', $revisionDoc)->with('quote', $revisionDoc->formatted_text);
                }
                else if ($revisionDoc->revisable_type == 'FI\Modules\RecurringInvoices\Models\RecurringInvoice')
                {
                    return view('document_revision._modal_recurring_invoice_view')->with('revisionDoc', $revisionDoc)->with('ri', $revisionDoc->formatted_text);
                }
                else if ($revisionDoc->revisable_type == 'Addons\ProformaInvoice\Models\ProformaInvoice')
                {
                    return view('document_revision._modal_proforma_invoice_view')->with('revisionDoc', $revisionDoc)->with('pi', $revisionDoc->formatted_text);
                }
                else
                {
                    return response()->json(['success' => false, 'message' => trans('fi.modal_not_found')], 400);
                }
            }
            else
            {
                return response()->json(['success' => false, 'message' => trans('fi.record_not_found')], 400);
            }
        }
        catch (\Exception $e)
        {
            return response()->json(['success' => false, 'message' => ($e->getCode() == 0) ? trans('fi.modal_not_found') : $e->getMessage()], 400);
        }
    }

    public function pdf($id)
    {
        $documentRevision = DocumentRevision::find($id);
        if ($documentRevision->text != null)
        {
            $invoice = json_decode($documentRevision->text, true);
            $pdf     = PDFFactory::create();
            $html    = darkModeForInvoiceAndQuoteTemplate($documentRevision->html);
            $pdfName = trans('fi.revision') . '_' . str_replace('/', '-', $invoice['number']) . '_' . $invoice['id'] . '.pdf';
            $pdf->download($html, $pdfName);
        }

    }

}
