@if(isset($label))
    <table class="table table-sm table-striped {{$surrogate ?'merge-table-two' : 'merge-table-one'}}">
        @foreach ($customFields as $customField)
            @if($customField->field_label == $label)
                <tr class="custom-{{$customField->column_name}}-{{$surrogate ?'two' : 'one'}}">
                    @if($surrogate)
                        <th scope="row" width="25%">
                            {!! Form::select('custom['.$customField->column_name.'##'.$client->custom->{$customField->column_name}.']',in_array($customField->field_type,['textarea','text','tagselection']) ? $dataSurrogateTwo : $dataSurrogateOne, null, ['data-field'=>'custom-'.$customField->column_name, 'class' => 'form-control form-control-sm p-0 merge-select-css']) !!}
                        </th>
                    @endif
                    <td class="col-md-2 custom-{{$customField->column_name}}-label-{{$surrogate ?'two' : 'one'}}">
                        <label class="d-flex align-items-center float-left mt-1 mb-1">
                            <i class="fa fa-circle text-warning d-none pr-2"></i>{!! $customField->field_label !!}
                        </label>
                    </td>

                    <td class="custom-{{$customField->column_name}}-text-{{$surrogate ?'two' : 'one'}}   col-md-{{ config('fi.customFieldsDisplayColumn') - 2 }}">

                         <span class="custom-{{$customField->column_name}}-merge-{{$surrogate ?'two' : 'one'}}">
                             @switch($customField->field_type)
                                 @case('text')
                                 @case('textarea')
                                 @case('date')
                                 @case('datetime')
                                 @case('currency')
                                 @case('phone')
                                 @case('decimal')
                                 @case('integer')
                                 {!! nl2br($client->customField($customField->field_label)) !!}
                                 @break
                                 @case('email')
                                 @if($client->custom->{$customField->column_name} != '')
                                     <a href="mailto:{!! $client->custom->{$customField->column_name} !!}">{!! $client->custom->{$customField->column_name} !!}</a>
                                 @endif
                                 @break
                                 @case('url')
                                 @if($client->custom->{$customField->column_name} != '')
                                     <a href="{!! $client->custom->{$customField->column_name} !!}"
                                        target="_blank">{!! $client->custom->{$customField->column_name} !!}</a>
                                 @endif
                                 @break
                                 @case('checkbox')
                                 {!! Form::checkbox('custom[' . $customField->column_name . ']',1, isset($object->custom->{$customField->column_name}) && $object->custom->{$customField->column_name} == 1 ? true : false, ['class' => 'custom-form-field', 'disabled']) !!}
                                 @break
                                 @case('radio')
                                 @case('dropdown')
                                 <?php $options = (array)$customField->options; ?>
                                 {!! $client->custom->{$customField->column_name} != '' && isset($options[$client->custom->{$customField->column_name}]) ? $options[$client->custom->{$customField->column_name}] : '' !!}
                                 @break
                                 @case('tagselection')
                                 <?php $tags = json_decode($object->custom->{$customField->column_name}); ?>
                                 @if(!empty($tags) && count($tags) > 0)
                                     @foreach ($tags as $tag)
                                         <span class="badge badge-default"
                                               style="font-size: 85%;">{{ $customField->options->{$tag} }}</span>
                                     @endforeach
                                 @endif
                                 @break
                                 @case('image')
                                 @if(isset($object->custom->{$customField->column_name}))
                                     <div class="custom_img">{!! $object->custom->imageView($customField->column_name,100) !!}</div>
                                 @endif
                                 @default
                             @endswitch
                            </span>
                        <span class="custom-{{$customField->column_name}}-merge-{{$surrogate ?'one':'two'}}"></span>
                    </td>
                </tr>
            @endif
        @endforeach
    </table>
@else
    <table class="table table-sm table-striped {{$surrogate ?'merge-table-two' : 'merge-table-one'}}">
        <tbody>
        @foreach ($customFields as $customField)
            <tr class="custom-{{$customField->column_name}}-{{$surrogate ?'two' : 'one'}}">
                @if($surrogate)
                    <th scope="row" width="25%">
                        {!! Form::select('custom['.$customField->column_name.'##'.$client->custom->{$customField->column_name}.']',in_array($customField->field_type,['textarea','text','tagselection']) ? $dataSurrogateTwo : $dataSurrogateOne, null, ['data-field'=>'custom-'.$customField->column_name, 'class' => 'form-control form-control-sm p-0 merge-select-css']) !!}
                    </th>
                @endif
                <td class="col-md-2 custom-{{$customField->column_name}}-label-{{$surrogate ?'two' : 'one'}}">
                    <label class="d-flex align-items-center float-left mt-1 mb-1">
                        <i class="fa fa-circle text-warning d-none pr-2"></i>{!! $customField->field_label !!}
                    </label>
                </td>
                <td class="custom-{{$customField->column_name}}-text-{{$surrogate ?'two' : 'one'}}   col-md-{{ config('fi.customFieldsDisplayColumn') - 2 }}">

                     <span class="custom-{{$customField->column_name}}-merge-{{$surrogate ?'two' : 'one'}}">
                            @switch($customField->field_type)
                             @case('text')
                             @case('textarea')
                             @case('date')
                             @case('datetime')
                             @case('currency')
                             @case('phone')
                             @case('decimal')
                             @case('integer')
                             {!! nl2br($client->customField($customField->field_label)) !!}
                             @break
                             @case('email')
                             @if($client->custom->{$customField->column_name} != '')
                                 <a href="mailto:{!! $client->custom->{$customField->column_name} !!}">{!! $client->custom->{$customField->column_name} !!}</a>
                             @endif
                             @break
                             @case('url')
                             @if($client->custom->{$customField->column_name} != '')
                                 <a href="{!! $client->custom->{$customField->column_name} !!}"
                                    target="_blank">{!! $client->custom->{$customField->column_name} !!}</a>
                             @endif
                             @break
                             @case('checkbox')
                             {!! Form::checkbox('custom[' . $customField->column_name . ']',1, isset($object->custom->{$customField->column_name}) && $object->custom->{$customField->column_name} == 1 ? true : false, ['class' => 'custom-form-field', 'disabled']) !!}
                             @break
                             @case('radio')
                             @case('dropdown')
                             <?php $options = (array)$customField->options; ?>
                             {!! $client->custom->{$customField->column_name} != '' && isset($options[$client->custom->{$customField->column_name}]) ? $options[$client->custom->{$customField->column_name}] : '' !!}
                             @break
                             @case('tagselection')
                             <?php $tags = json_decode($object->custom->{$customField->column_name}); ?>
                             @if(!empty($tags) && count($tags) > 0)
                                 @foreach ($tags as $tag)
                                     <span class="badge badge-default"
                                           style="font-size: 85%;">{{ $customField->options->{$tag} }}</span>
                                 @endforeach
                             @endif
                             @break
                             @case('image')
                             @if(isset($object->custom->{$customField->column_name}))
                                 <div class="custom_img">{!! $object->custom->imageView($customField->column_name,100) !!}</div>
                             @endif
                             @default
                         @endswitch
                     </span>
                    <span class="custom-{{$customField->column_name}}-merge-{{$surrogate ?'one':'two'}}"></span>

                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
@endif
