<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Countries\Models;

use Illuminate\Support\Facades\Cache;

class CountryObserver
{
    public function created(Country $country)
    {
        Cache::forget('selectRawCountriesCache');
    }

    public function updated(Country $country)
    {
        Cache::forget('selectRawCountriesCache');
    }

    public function deleted(Country $country)
    {
        Cache::forget('selectRawCountriesCache');
    }

}