<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

Route::group(['middleware' => ['web', 'auth.admin'], 'prefix' => 'clients', 'namespace' => 'FI\Modules\Contacts\Controllers'], function ()
{

    Route::group(['prefix' => '{clientId}/contacts'], function ()
    {
        Route::get('index', ['uses' => 'ContactController@index', 'as' => 'clients.contacts.index.default'])->middleware('can:contacts.create');
        Route::get('create', ['uses' => 'ContactController@create', 'as' => 'clients.contacts.create'])->middleware('can:contacts.create');
        Route::post('create', ['uses' => 'ContactController@store', 'as' => 'clients.contacts.store'])->middleware('can:contacts.create');
        Route::get('edit/{contactId}', ['uses' => 'ContactController@edit', 'as' => 'clients.contacts.edit'])->middleware('can:contacts.update');
        Route::post('edit/{contactId}', ['uses' => 'ContactController@update', 'as' => 'clients.contacts.update'])->middleware('can:contacts.update');
        Route::post('delete', ['uses' => 'ContactController@delete', 'as' => 'clients.contacts.delete'])->middleware('can:contacts.delete');
        Route::post('default', ['uses' => 'ContactController@updateDefault', 'as' => 'clients.contacts.updateDefault'])->middleware('can:contacts.update');
        Route::post('delete/modal', ['uses' => 'ContactController@deleteContactModal', 'as' => 'clients.delete.contact.modal'])->middleware('can:clients.delete');
    });
});