@include('layouts._intl-tel-input')
<script type="text/javascript">
    $(function () {
        var modalContact = $('#modal-contact');

        modalContact.modal();

        $('[data-toggle="tooltip"]').tooltip({
            'delay': {show: 1100, hide: 100}
        });

        $('#contact-generic-tag').select2({tags: true, tokenSeparators: [",", " "]});

        $('#btn-contact-submit').click(function () {

            $.post("{{ $submitRoute }}", $('#client-contact').serialize()).fail(function (response) {
                showAlertifyErrors($.parseJSON(response.responseText).errors);
            }).done(function (response) {
                modalContact.modal('hide');
                @if ($editMode)
                alertify.success('{{ trans('fi.contact_updated') }}', 5);
                @else
                alertify.success('{{ trans('fi.contact_added') }}', 5);
                @endif
                $('#tab-contacts .tab-contacts-card-body .table-contact-row').html(response);
                let count = $('.contacts-tbody').children().length
                $('.contacts-tab-count').text(count);
                initTooltip();
            });

        });

        $('.modal-contact-close').click(function () {
            $('.btn-action-modal').removeClass('disabled');
        });

        $(".js-contact-phone").intlTelInput({
            autoHideDialCode: false,
            autoPlaceholder: false,
            nationalMode: false,
            preferredCountries: ["{{ $defaultCountry }}"],
        });

        var showAlertForNumber = true;
        var numberType = '';

        $('.alert-dismissible-btn').on('click', function () {
            showAlertForNumber = false;
            $('.alert-warning-toggle').addClass('d-none').removeClass('d-block');
        });

        $('#primary_phone, #alternate_phone').on('input', function () {

            let countryCodeId = $(this).data('code-id');
            let countryCode = $('#' + countryCodeId).val();
            var countryCodeNumeric = countryCode.replace(/\D/g, '');
            var phoneNumber = $(this).val();
            var numericValue = phoneNumber.replace(/\D/g, '');

            if (phoneNumber !== numericValue && numericValue !== '+')
            {
                alertify.error('{{ trans('fi.phone_number_numeric_error') }}', 5);
            }

            if (numberType != '' && numberType != countryCodeId)
            {
                showAlertForNumber = true;
            }

            $(this).val(numericValue);
            var aString = numericValue.toString();
            var bString = countryCodeNumeric.toString();

            if (aString !== bString)
            {
                if (aString.startsWith(bString))
                {
                    if (showAlertForNumber)
                    {
                        $('.alert-warning-toggle').addClass('d-block').removeClass('d-none');
                    }
                }
                else
                {
                    $(this).val(numericValue);
                    $('.alert-warning-toggle').addClass('d-none').removeClass('d-block');
                }
            }
            else
            {
                if (showAlertForNumber)
                {
                    $('.alert-warning-toggle').addClass('d-block').removeClass('d-none');
                }
            }
            numberType = countryCodeId;
        });
    });
</script>

<div class="modal" id="modal-contact" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    @if ($editMode)
                        {{ trans('fi.edit_contact') }}
                    @else
                        {{ trans('fi.add_contact') }}
                    @endif
                </h5>
                <button type="button" class="close modal-contact-close" data-dismiss="modal" aria-hidden="true">
                    &times;
                </button>
            </div>
            <div class="modal-body">
                <form class="form-horizontal" id="client-contact" name="client-contact">
                    <div class="row">
                        <div id="modal-status-placeholder"></div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>{{ trans('fi.name') }}:</label>
                                {!! Form::text('name', ($editMode) ? $contact->name : null, ['class' => 'form-control form-control-sm ', 'id' => 'contact_name']) !!}
                            </div>
                        </div>
                        <div class="offset-md-1 col-md-3">
                            <div class="form-group">
                                <label>{{ trans('fi.title') }}:</label>
                                {!! Form::select('title', $contactTitle, ($editMode) ? $contact->title : null, ['id' => 'title', 'class' => 'form-control form-control-sm']) !!}
                            </div>
                        </div>
                        <div class="offset-md-1 col-md-3">
                            <div class="form-group">
                                <label>{{ trans('fi.status') }}:</label>
                                {!! Form::select('status', ['1' => trans('fi.active'), '0' => trans('fi.inactive')], ($editMode) ? $contact->status : null, ['id' => 'status', 'class' => 'form-control form-control-sm']) !!}
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label data-toggle="tooltip" data-placement="auto"
                                       title="{!! trans('fi.tags') !!}">{{ trans('fi.tags') }}: </label>
                                {!! Form::select('tags[]', $contactTags, $contactSelectedTags, ['class' => 'form-control form-control-sm contact-generic-tag','multiple' => true, 'id' => 'contact-generic-tag', 'style' => 'width:100%']) !!}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12 alert-warning-toggle d-none">
                            <div class="alert alert-warning alert-dismissible">
                                <button type="button" class="close  alert-dismissible-btn" aria-hidden="true">×</button>
                                <h6 class="m-0">
                                    <i class="icon fas fa-exclamation-triangle"></i>
                                    {{trans('fi.phone_num_same_country_code_error')}} !
                                </h6>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{{ trans('fi.primary_phone') }}:</label>
                                <div class="input-group  input-group-sm">
                                    <div class="row">
                                        <div class="col-3 pr-0">
                                            {!! Form::text('primary_isd_code', ($editMode) ? $contact->primary_isd_code : old('primary_isd_code'), ['class' => 'form-control form-control-sm border-right-0 radius-right-0 js-contact-phone', 'id' =>'primary_isd_code']) !!}
                                        </div>
                                        <div class="col-9 pl-0">
                                            {!! Form::text('primary_phone',($editMode) ? $contact->primary_phone : null , ['class' => 'form-control form-control-sm radius-left-0', 'id' =>'primary_phone', 'data-code-id'=>'primary_isd_code']) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label data-toggle="tooltip" data-placement="auto"
                                       title="{!! trans('fi.is_mobile') !!}">{{ trans('fi.is_mobile') }}:</label>
                                {!! Form::select('primary_is_mobile', ['0' => trans('fi.no'), '1' => trans('fi.yes')], ($editMode) ? $contact->primary_is_mobile : null, ['id' => 'primary_is_mobile', 'class' => 'form-control form-control-sm']) !!}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{{ trans('fi.alternate_phone') }}:</label>
                                <div class="input-group  input-group-sm">
                                    <div class="row">
                                        <div class="col-3 pr-0">
                                            {!! Form::text('alternate_isd_code', ($editMode) ? $contact->alternate_isd_code : old('alternate_isd_code'), ['class' => 'form-control form-control-sm border-right-0 radius-right-0 js-contact-phone', 'id' =>'alternate_isd_code']) !!}
                                        </div>
                                        <div class="col-9 pl-0">
                                            {!! Form::text('alternate_phone',($editMode) ? $contact->alternate_phone : null , ['class' => 'form-control form-control-sm radius-left-0', 'id' =>'alternate_phone', 'data-code-id'=>'alternate_isd_code']) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label data-toggle="tooltip" data-placement="auto"
                                       title="{!! trans('fi.is_mobile') !!}">{{ trans('fi.is_mobile') }}:</label>
                                {!! Form::select('alternate_is_mobile', ['0' => trans('fi.no'), '1' => trans('fi.yes')], ($editMode) ? $contact->alternate_is_mobile : null, ['id' => 'alternate_is_mobile', 'class' => 'form-control form-control-sm']) !!}
                            </div>
                        </div>

                        <div class="col-md-12 pt-3 pb-3">
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{{ trans('fi.email') }}:</label>
                                {!! Form::text('email', ($editMode) ? $contact->email : null, ['class' => 'form-control form-control-sm', 'id' => 'contact_email']) !!}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label data-toggle="tooltip" data-placement="auto"
                                       title="{!! trans('fi.tt_default_to') !!}">{{ trans('fi.default_to') }}:</label>
                                {!! Form::select('default_to', $getDefaultStatusListForToBccAndCc, ($editMode) ? $contact->default_to : null, ['id' => 'default_to', 'class' => 'form-control form-control-sm']) !!}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label data-toggle="tooltip" data-placement="auto"
                                       title="{!! trans('fi.tt_default_cc') !!}">{{ trans('fi.default_cc') }}:</label>
                                {!! Form::select('default_cc', $getDefaultStatusListForToBccAndCc, ($editMode) ? $contact->default_cc : null, ['id' => 'default_cc', 'class' => 'form-control form-control-sm']) !!}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label data-toggle="tooltip" data-placement="auto"
                                       title="{!! trans('fi.tt_default_bcc') !!}">{{ trans('fi.default_bcc') }}:</label>
                                {!! Form::select('default_bcc', $getDefaultStatusListForToBccAndCc, ($editMode) ? $contact->default_bcc : null, ['id' => 'default_bcc', 'class' => 'form-control form-control-sm']) !!}
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>{{ trans('fi.notes') }}:</label>
                                {!! Form::textarea('notes', ($editMode) ? $contact->notes : null, ['class' => 'form-control form-control-sm', 'id' => 'contact_notes', 'rows' => 3]) !!}
                            </div>
                        </div>
                    </div>
                    {!! Form::hidden('client_id', $clientId) !!}
                </form>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-sm btn-default modal-contact-close"
                        data-dismiss="modal">{{ trans('fi.cancel') }}</button>
                <button type="button" id="btn-contact-submit"
                        class="btn btn-sm btn-primary">{{ trans('fi.save') }}</button>
            </div>
        </div>
    </div>
</div>
