<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\CompanyProfiles\Requests;

use FI\Traits\CustomFieldValidator;
use Illuminate\Foundation\Http\FormRequest;
use FI\Requests\RemoveTagsRule;

class CompanyProfileStoreRequest extends FormRequest
{
    use CustomFieldValidator;

    private $customFieldType = 'company_profiles';

    public function authorize()
    {
        return true;
    }

    public function attributes()
    {
        return ['company' => trans('fi.company')];
    }

    public function rules()
    {
        return [
            'company'    => ['required', 'unique:company_profiles,company', new RemoveTagsRule],
            'logo'       => 'nullable|image|mimes:jpeg,png,jpg,gif',
            'address'    => [new RemoveTagsRule],
            'vat_detail' => [new RemoveTagsRule],
            'city'       => [new RemoveTagsRule],
            'state'      => [new RemoveTagsRule],
            'zip'        => [new RemoveTagsRule],
            'phone'      => [new RemoveTagsRule],
            'fax'        => [new RemoveTagsRule],
            'mobile'     => [new RemoveTagsRule],
            'web'        => [new RemoveTagsRule],
        ];
    }
}