<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\CompanyProfiles\Models;

use FI\Modules\CustomFields\Models\CompanyProfileCustom;
use Illuminate\Support\Facades\Cache;

class CompanyProfileObserver
{
    public function created(CompanyProfile $companyProfile)
    {
        Cache::forget('getListCompanyProfileCache');
        $companyProfile->custom()->save(new CompanyProfileCustom());
    }

    public function creating(CompanyProfile $companyProfile)
    {
        if (!$companyProfile->invoice_template)
        {
            $companyProfile->invoice_template = config('fi.invoiceTemplate');
        }

        if (!$companyProfile->quote_template)
        {
            $companyProfile->quote_template = config('fi.quoteTemplate');
        }
    }

    public function updated(CompanyProfile $companyProfile)
    {
        Cache::forget('getListCompanyProfileCache');
    }

    public function deleted(CompanyProfile $companyProfile)
    {
        Cache::forget('getListCompanyProfileCache');

        if($companyProfile->custom)
        {
            $companyProfile->custom->delete();
        }
    }

    public function saving(CompanyProfile $companyProfile)
    {
        $companyProfile->address = strip_tags($companyProfile->address);
    }
}