@extends('layouts.master')
<style>
    .merge-table > tbody > tr > td {
        overflow: auto;
        white-space: nowrap;
    }

    .color-add {
        background-color: #f0ad4e;
        width: 1px !important;
    }

    .through-data {
        text-decoration: line-through;
        pointer-events: none;
        opacity: 0.7;
    }

    .add-blue-color-text {
        color: #0000ff;
    }
</style>
@section('javascript')
    @include('layouts._select2')

    <script type="text/javascript">
        $(function () {
            var settings = {
                placeholder: '{{ trans('fi.select_client') }}',
                allowClear: true,
                escapeMarkup: function (markup) {
                    return markup;
                }
            };

            $('.merge-clients').select2(settings);

            @if($id != null && $id != 0)
            $('#client_to').val('{{$id}}').trigger('change').select2(settings);
            clientTo('{{$id}}');

            @endif


            function clientTo(id)
            {
                showHideLoaderModal();
                $('#client_from option').prop('disabled', false);
                $('#client_from option[value="' + id + '"]').prop('disabled', true);

                $.post("{{route('ajax.get.client.record')}}", {
                    id: id,
                    clientFrom: $('#client_from').val(),
                }).done(function (response) {
                    showHideLoaderModal();
                    $('#client-to-render').html(response);
                }).fail(function (response) {
                    showHideLoaderModal();
                    $('#client-to-render').html('');
                    alertify.error($.parseJSON(response.responseText).message, 5);
                });
            }

            $('#client_to').change(function () {
                if ($('#client_from').val() != null && $(this).val() != null && $('#client_from').val() == $(this).val())
                {
                    $('#client-to-render').html('');
                    $('#client_to').val(null).trigger('change');
                }
                else
                {
                    clientTo($('#client_to').val());
                }
            });


            $('#client_from').change(function () {

                if ($('#client_to').val() != null && $(this).val() != null && $('#client_to').val() == $(this).val())
                {
                    $('#client-from-render').html('')
                    $('#client_from').val(null).trigger('change');
                }
                else
                {
                    showHideLoaderModal();
                    $.post("{{route('ajax.get.client.record')}}", {
                        id: $('#client_from').val(),
                        surrogate: true,
                        clientTo: $('#client_to').val(),
                    }).done(function (response) {
                        showHideLoaderModal();
                        $('#client-from-render').html(response);
                    }).fail(function (response) {
                        showHideLoaderModal();
                        $('#client-from-render').html('');
                        alertify.error($.parseJSON(response.responseText).message, 5);
                    });
                }
            });

            $('.merge-client-records-confirm').click(function (evt) {
                evt.stopPropagation();
                evt.preventDefault();
                var formData = $('#merge-client-records-form').serializeFormJSON();

                $('#modal-placeholder').load('{!! route('client.merge.modal') !!}', formData,
                    function (response, status, xhr) {
                        if (status == "error")
                        {
                        }
                    }
                );
            });

            $(document).on('change', '.merge-select-css', function () {

                var action = $(this).val();
                var field = $(this).data('field');
                var oneMainTr = $('.merge-table-one').find('.' + field + '-one > .' + field + '-label-one');
                var secondMainHtml = $('.merge-table-two').find('.' + field + '-two > .' + field + '-text-two > .' + field + '-merge-two').html();

                if (action == 'overwrite')
                {
                    oneMainTr.children().children('.text-warning').removeClass('d-none').addClass('d-block');
                    $('.merge-table-one').find('.' + field + '-one > .' + field + '-text-one> .' + field + '-merge-one').addClass('through-data').next().removeClass('add-blue-color-text').html('<br>' + secondMainHtml);
                }
                else if (action == 'add_to')
                {
                    oneMainTr.children().children('.text-warning').removeClass('d-none').addClass('d-block');
                    $('.merge-table-one').find('.' + field + '-one > .' + field + '-text-one> .' + field + '-merge-one').removeClass('through-data').next().addClass('add-blue-color-text').html(secondMainHtml);
                }
                else
                {
                    oneMainTr.children().children('.text-warning').removeClass('d-block').addClass('d-none');
                    $('.merge-table-one').find('.' + field + '-one > .' + field + '-text-one> .' + field + '-merge-one').removeClass('through-data').next().removeClass('add-blue-color-text').html('');
                }
            });
        });
    </script>
@stop

@section('content')
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-12 d-none d-sm-block">
                    <ol class="breadcrumb float-sm-right">{!!  breadcrumbs() !!}</ol>
                </div>
            </div>
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="d-inline">{!! trans('fi.merge') !!}</h1>
                </div>
                <div class="col-sm-6 text-right" style="padding-top:7px;">
                    @if ($returnUrl)
                        <a href="{{ $returnUrl }}" class="btn btn-sm btn-default mr-2">
                            <i class="fa fa-backward"></i> {{ trans('fi.back') }}
                        </a>
                    @endif
                    <button type="submit" id="merge-client-records-confirm"
                            class="merge-client-records-confirm btn btn-sm btn-primary mr-2"
                            href="#">
                        <i class="fa fa-save"></i> {{ trans('fi.save') }}
                    </button>
                </div>
            </div>
        </div>
    </section>
    <section class="content">
        <div class="container-fluid">
            @include('layouts._alerts')

            <div class="row">
                <div class="col-12">
                    <div class="card card-primary card-outline card-outline-tabs">
                        <div class="card-body">
                            {!! Form::open(['method' => 'POST', 'url' => route('merge.set.client.record'), 'id' => 'merge-client-records-form']) !!}
                            <div class="row">
                                <div class="col-md-5 p-0">
                                    <div class="col-md-12 text-center">
                                        <h3 class="font-weight-bolder">{{trans('fi.primary_merge_to_client')}}</h3>
                                        <div class="dropdown-divider"></div>
                                    </div>
                                    <div class="col-md-12 mb-2">
                                        <div class="form-group">
                                            <label> {{ trans('fi.client') }}:</label>
                                            {!! Form::select('client_to', $clients, request('client_to'), ['id' => 'client_to', 'class' => 'form-control form-control-sm merge-clients', 'autocomplete' => 'off', 'style' => 'width: 100%;']) !!}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2 p-0 m-auto fa-3x text-center">
                                    <i class="fa fa-arrow-left"></i>
                                </div>
                                <div class="col-md-5 p-0">
                                    <div class="col-md-12 text-center">
                                        <h3 class="font-weight-bolder">{{trans('fi.surrogate_merge_from_client')}}</h3>
                                        <div class="dropdown-divider"></div>
                                    </div>
                                    <div class="col-md-12 mb-2">
                                        <div class="form-group">
                                            <label> {{ trans('fi.client') }}:</label>
                                            {!! Form::select('client_from', $clients, request('client_from'), ['id' => 'client_from', 'class' => 'form-control form-control-sm merge-clients', 'autocomplete' => 'off','style' => 'width: 100%;']) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 p-0">
                                    <div class="col-md-12 client-to-render"
                                         id="client-to-render"></div>
                                </div>
                                <div class="col-md-6 p-0">
                                    <div class="col-md-12 client-from-render"
                                         id="client-from-render"></div>
                                </div>
                            </div>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>

            </div>

        </div>
        <div class="pull-right pb-2">
            @if ($returnUrl)
                <a href="{{ $returnUrl }}" class="btn btn-sm btn-default mr-2">
                    <i class="fa fa-backward"></i> {{ trans('fi.back') }}
                </a>
            @endif
            <button type="submit" id="merge-client-records-confirm"
                    class="merge-client-records-confirm btn btn-sm btn-primary mr-2"
                    href="#">
                <i class="fa fa-save"></i> {{ trans('fi.save') }}
            </button>
        </div>
    </section>
    <div class="modal" id="merge-modal-loader" style="opacity: 0.8;">
        <div class="overlay text-center position-absolute p-3"
             style="left: 50%;top: 50%;-webkit-transform: translateX(-50%) translateY(-50%);transform: translateX(-50%) translateY(-50%);">
            <img src="{{ asset('assets/dist/img/merge.gif') }}"
                 style=" width: 50%; background: #dcdcdc; border-radius: 50%; transform: rotate(180deg)">
        </div>
    </div>
@stop