@extends('layouts.master')
@include('layouts._formdata')
@section('javascript')

    <script type="text/javascript">
        $(function () {
            $('.nav-item').click(function () {
                $('#client-edit-form').attr('action', $(this).data('save-link'));
            });

            let selectedTab = '#{{ $selectedTab }}' + '-tab';
            $(selectedTab).trigger('click');


            $(document).on('change', '#company_profile_id', function () {
                getPaymentTermId($(this).val())
            });

            function getPaymentTermId(company_profile_id)
            {
                if (company_profile_id)
                {
                    var client_data = {};
                    client_data['company_profile_id'] = company_profile_id;

                    $.ajax({
                        url: "{{ route('clients.ajax.getPaymentTermId') }}",
                        method: 'post',
                        data: client_data,
                        beforeSend: function () {
                            $(".modal-loader").show();
                        },
                        success: function (response) {
                            $(".modal-loader").hide();
                            $('.client_payment_term_id option[value=' + response.payment_term_id + ']').prop("selected", true);
                            $('.client_payment_term_id').trigger('change');
                        },
                        error: function (XMLHttpRequest, textStatus, error) {
                            alertify.error(XMLHttpRequest.responseJSON.message, 5);
                        }
                    });
                }

            }

            @if (!$editMode)
                getPaymentTermId($('#company_profile_id').val())
            @endif
        });
    </script>
    <script>
        $(function () {
            $('.data-changes-check').data('serialize', $('.data-changes-check').serializeFormJSON());
            var beforeunload = true;

            $(window).bind('beforeunload', function (e) {
                const formData1 = $('.data-changes-check').data('serialize');
                const formData2 = $('.data-changes-check').serializeFormJSON();
                const currentSerializedFormData1 = JSON.stringify(formData1);
                const currentSerializedFormData2 = JSON.stringify(formData2);
                const currentFormData1 = JSON.parse(currentSerializedFormData1);
                const currentFormData2 = JSON.parse(currentSerializedFormData2);

                const areFormObjectsEqual = areObjectsEqual(currentFormData1, currentFormData2, false);

                if ((!areFormObjectsEqual || !filesChecks) && beforeunload)
                {
                    return true;
                }
            });

            $(document).off('click', '.data-submit').on('click', '.data-submit', function (evt) {
                evt.stopPropagation();
                evt.preventDefault();
                beforeunload = false;
                var formAllDataArray = $('form').serializeArray();
                var new_array = {};
                var customFields = {};
                var selectCustomRadioButtonValue = null;
                $('#custom-body-table').find('.custom-file-input,.custom-form-field,.form-check-input').each(function () {
                    var fieldName = $(this).data('clients-field-name');
                    var inputType = $(this).attr('type') || this.tagName.toLowerCase();
                    if (fieldName !== undefined)
                    {
                        if ('file' === inputType)
                        {
                            customFields[fieldName] = typeof this.files[0] === 'undefined' ? '' : this.files[0];
                            return true;
                        }
                        if ('select' === inputType)
                        {
                            if ($(this).find('option:selected').length == 0)
                            {
                                customFields[fieldName] = '';
                                return true;
                            }
                        }
                        if ('checkbox' === inputType)
                        {
                            customFields[fieldName] = ($(this).is(":checked")) ? 1 : 0;
                            return true;
                        }
                        if ('radio' === inputType)
                        {
                            if ($(this).prop('checked') == true)
                            {
                                customFields[fieldName] = $(this).val();
                                selectCustomRadioButtonValue = $(this).val();
                            }
                            if ($(this).prop('checked') == false && selectCustomRadioButtonValue == null)
                            {
                                customFields[fieldName] = 'null';
                            }
                            return customFields[fieldName];
                        }
                        customFields[$(this).data('clients-field-name')] = $(this).val();
                    }
                });

                formAllDataArray.forEach(function (item) {
                    let formKey = item.name;
                    var filter_column = formKey.substring(0, formKey.lastIndexOf("]") + 1);
                    let result = filter_column.startsWith("custom", 0);
                    if (result === false)
                    {
                        if (item.name === 'address')
                        {
                            new_array[item.name] = (item.value).replace(/(\r\n|\r|\n){2}/g, '$1').replace(/(\r\n|\r|\n){3,}/g, '$1\n');
                        }
                        else if (item.name === 'tags')
                        {
                        }
                        else if (item.name === 'tags[]')
                        {
                            new_array['tags'] = '';
                            if (item.value != 0 && item.value != 1)
                            {
                                new_array['tags'] = $('.client-tags').val();
                            }
                        }
                        else
                        {
                            new_array[item.name] = item.value;
                        }
                    }
                });

                $.each(customFields, function (custom_key, custom_value) {
                    new_array['custom[' + custom_key + ']'] = custom_value;
                });
                new_array['name'] = $('#client_name').val();
                var client_url = $('form').attr('action');

                var form_data;
                form_data = objectToFormData(new_array);

                $.ajax({
                    url: client_url,
                    method: 'post',
                    data: form_data,
                    async: false,
                    processData: false,
                    contentType: false,
                }).done(function (response) {
                    @if ($editMode)
                    var url = '{{route('clients.show',['id' => $client->id])}}';
                    window.location.replace(url);
                    alertify.success(response.alertSuccess);
                    @else
                    if (response.duplicate == true)
                    {
                        $('#modal-placeholder').load("{{route('clients.get.duplicateName') }}", {data: response.duplicateData});
                    }
                    else
                    {
                        var url = '{{route('clients.show',['id' => ':id'])}}';
                        url = url.replace(':id', response.clientId);
                        window.location.replace(url);
                        alertify.success(response.alertSuccess);
                    }
                    @endif
                })
                    .fail(function (response) {
                        $.each($.parseJSON(response.responseText).errors, function (id, message) {
                            alertify.error(message[0], 5);
                        });
                    });
            });

            @if ($editMode)
            $('#btn-add-contact').click(function () {
                $('#modal-placeholder').load('{{ route('clients.contacts.create', [$client->id]) }}');
            });
            @endif
        });
    </script>

@stop

@section('content')

    @if ($editMode)
        {!! Form::model($client, ['route' => ['clients.update', $client->id, 'tab' => $selectedTab], 'enctype'=>'multipart/form-data', 'id' => 'client-edit-form', 'class'=>'data-changes-check','data-serialize'=>'','data-initialFileData'=>'']) !!}

        {!!  Form::hidden('client_id', $client->id,['id' => 'client_id']) !!}
        {!!  Form::hidden('custom_module', 'client',['id' => 'custom_module']) !!}
    @else
        {!! Form::open(['route' => 'clients.store', 'enctype'=>'multipart/form-data', 'class'=>'data-changes-check','data-serialize'=>'','data-initialFileData'=>'']) !!}
    @endif

    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-12 d-none d-sm-block">
                    <ol class="breadcrumb float-sm-right">{!!  breadcrumbs() !!}</ol>
                </div>
            </div>
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="pull-left d-inline">
                        {{ trans('fi.client_form') }}
                    </h1>
                    @if ($editMode)
                        <span class="badge {{ isset($typeLabels[$client->type]) ? $typeLabels[$client->type] : '' }}">
                            {{ trans('fi.' . $client->type) }}
                        </span>
                        {{ $client->name }}
                    @endif
                </div>
                <div class="col-sm-6">
                    <div class="text-right">
                        @if ($editMode)
                            <a href="{{ $returnUrl }}" class="btn btn-sm btn-default">
                                <i class="fa fa-backward"></i> {{ trans('fi.back') }}
                            </a>
                        @endif
                        <button class="btn btn-sm btn-primary data-submit">
                            <i class="fa fa-save"></i> {{ trans('fi.save') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="content">

        <div class="container-fluid">

            @include('layouts._alerts')

            <div class="row">

                <div class="col-12">
                    <div class="card card-primary card-outline card-outline-tabs">
                        <div class="card-header p-0 border-bottom-0">
                            <ul class="nav nav-tabs" role="tablist">
                                @if ($editMode)
                                    <li class="nav-item"
                                        data-save-link="{{ route('clients.update', [$client->id, 'tab' => 'general']) }}">
                                        <a class="active nav-link" id="general-tab" href="#tab-general"
                                           data-toggle="tab">
                                            {{ trans('fi.general') }}
                                        </a>
                                    </li>
                                    @can('contacts.view')
                                        <li class="nav-item"
                                            data-edit-link="{{ route('clients.update', [$client->id, 'tab' => 'contacts']) }}">
                                            <a class="nav-link" id="contacts-tab" data-toggle="tab" href="#tab-contacts">
                                                {{ trans('fi.contacts') }} {!! $client->contacts->count() > 0 ? '<span class="badge badge-primary contacts-tab-count">'.$client->contacts->count().'</span>' : '' !!}
                                            </a>
                                        </li>
                                    @endcan
                                    @can('attachments.view')
                                        <li class="nav-item"
                                            data-save-link="{{ route('clients.update', [$client->id, 'tab' => 'attachments']) }}">
                                            <a class="nav-link" id="attachments-tab" href="#tab-attachments"
                                               data-toggle="tab">
                                                {{ trans('fi.attachments') }} {!! $client->attachments->count() > 0 ? '<span class="badge badge-default">'.$client->attachments->count().'</span>' : '' !!}
                                            </a>
                                        </li>
                                    @endcan
                                    @can('notes.view')
                                        <li class="nav-item"
                                            data-save-link="{{ route('clients.update', [$client->id, 'tab' => 'notes']) }}">
                                            <a class="nav-link" id="notes-tab" data-toggle="tab" href="#tab-notes">
                                                {{ trans('fi.notes') }}
                                                @if($client->notes->count() > 0)
                                                    <span class="badge badge-primary" id="notes-count">
                                                        {{ $client->notes->count() }}
                                                    </span>
                                                @endif
                                            </a>
                                        </li>
                                    @endcan
                                    <li class="nav-item"
                                        data-save-link="{{ route('clients.update', [$client->id, 'tab' => 'settings']) }}">
                                        <a id="settings-tab" href="#tab-settings" class="nav-link" data-toggle="tab">
                                            {{ trans('fi.settings') }}
                                        </a>
                                    </li>
                                @else
                                    <li class="nav-item">
                                        <a id="general-tab" href="#tab-general" class="active nav-link"
                                           data-toggle="tab">{{ trans('fi.general') }}</a>
                                    </li>
                                    <li class="nav-item">
                                        <a id="settings-tab" href="#tab-settings" class="nav-link"
                                           data-toggle="tab">{{ trans('fi.settings') }}</a>
                                    </li>
                                @endif
                            </ul>
                        </div>
                        <div class="card-body">
                            <div class="tab-content">
                                <div class="tab-pane active" id="tab-general">
                                    @include('clients._form')
                                </div>
                                @if ($editMode)
                                    @can('contacts.view')
                                        <div id="tab-contacts" class="tab-pane">
                                            <div class="card">
                                                <div class="card-header">
                                                    @can('contacts.create')
                                                        <div class="card-tools m-0">
                                                            <a href="javascript:void(0)"
                                                               class="btn btn-sm border-0 btn-primary {{(!$client->active) ? 'disabled' : null }}"
                                                               id="btn-add-contact">
                                                                <i class="fa fa-plus"></i> {{ trans('fi.add_contact') }}
                                                            </a>
                                                        </div>
                                                    @endcan
                                                </div>
                                                <div class="card-body table-responsive tab-contacts-card-body">
                                                    @include('contacts._table_contacts')
                                                </div>
                                            </div>
                                        </div>
                                    @endcan
                                    @can('attachments.view')
                                        <div class="tab-pane" id="tab-attachments">
                                            @include('attachments._table', ['object' => $client, 'model' => 'FI\Modules\Clients\Models\Client', 'modelId' => $client->id])
                                        </div>
                                    @endcan
                                    @can('notes.view')
                                        <div id="tab-notes" class="tab-pane">
                                            @include('notes._js_timeline', ['object' => $client, 'model' => 'FI\Modules\Clients\Models\Client', 'hideHeader' => true, 'showPrivateCheckbox' => 0, 'showPrivate' => 1])
                                            <div id="note-timeline-container"></div>
                                        </div>
                                    @endcan
                                @endif
                                <div class="tab-pane" id="tab-settings">
                                    @include('clients._settings')
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>

            <div class="pull-right pb-2">
                @if ($editMode)
                    <a href="{{ $returnUrl }}" class="btn btn-sm btn-default"><i
                                class="fa fa-backward"></i> {{ trans('fi.back') }}</a>
                @endif
                <button class="btn btn-sm btn-primary data-submit"><i class="fa fa-save"></i> {{ trans('fi.save') }}
                </button>
            </div>

        </div>

    </section>

    {!! Form::close() !!}

@stop