<table class="table table-hover table-striped table-sm text-nowrap">
    <thead>
    <tr>
        <th>{!! trans('fi.status') !!}</th>
        <th>{!! trans('fi.title') !!}</th>
        <th>{!! trans('fi.description') !!}</th>
        <th>
            <a href="#" class="task-due-date-short" data-client_id="{{$client->id}}" data-type="sort_due">
                {!! trans('fi.due_date') !!}
                @if(request('sort_due') === 'desc')
                    <i class="fa fa-xs fa-arrow-down"></i>
                @elseif(request('sort_due') === 'asc')
                    <i class="fa fa-xs fa-arrow-up"></i>
                @endif
            </a>
        </th>
        <th>
            <a href="#" class="task-due-date-short" data-client_id="{{$client->id}}" data-type="sort_assignee">

                {!! trans('fi.assignee') !!}
                @if(request('sort_assignee') === 'desc')
                    <i class="fa fa-xs fa-arrow-down"></i>
                @elseif(request('sort_assignee') === 'asc')
                    <i class="fa fa-xs fa-arrow-up"></i>
                @endif
            </a>
        </th>
        <th>
            <a href="#" class="task-due-date-short" data-client_id="{{$client->id}}" data-type="sort_completed">
                {!! trans('fi.completed') !!}
                @if(request('sort_completed') === 'desc')
                    <i class="fa fa-xs fa-arrow-down"></i>
                @elseif(request('sort_completed') === 'asc')
                    <i class="fa fa-xs fa-arrow-up"></i>
                @endif
            </a>
        </th>
        <th class="text-right">{!! trans('fi.options') !!}</th>
    </tr>
    </thead>
    <tbody>
    @foreach ($tasks as $task)
        <tr class="{{ $task->is_complete ? 'text-decoration-line-through' : '' }}">
            <td>
                <a href="javascript:void(0)" class="{{($task->is_complete == 0) ? 'action-complete' : 'action-reopen'}}"
                   data-task-id="{{ $task->id }}"
                   data-tab="tasks" data-redirect-to="{{ request()->fullUrl() }}">
                    {!! $task->formatted_status !!}
                </a>
            </td>
            <td>
                @if($task->user_id == auth()->user()->id || $task->assignee_id == auth()->user()->id)
                    <a href="{{ route('task.show', $task->id) }}">{!!    $task->title!!}</a>
                @else
                    {{ $task->title }}
                @endif
            </td>

            <td>{!! $task->formatted_description !!}</td>
            <td>{!! $task->formatted_due_date !!}</td>
            <td>{{$task->formatted_assignee}}</td>
            <td>{!! $task->formatted_completed_date !!}</td>
            <td class="text-right">
                @if($task->user_id == auth()->user()->id || $task->assignee_id == auth()->user()->id)

                    <div class="btn-group action-menu">
                        <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                            {{ trans('fi.options') }} <span class="caret"></span>
                        </button>
                        <div class="dropdown-menu dropdown-menu-right">
                            <a class="dropdown-item" href="{{ route('task.show', [$task->id]) }}"
                               id="view-task-{{ $task->id }}">
                                <i class="fa fa-search"></i> {{ trans('fi.view') }}</a>
                            </li>
                            @if($task->is_complete == 0)

                                <a href="javascript:void(0)" class="action-complete-with-note dropdown-item"
                                   data-task-title="{{ $task->title}}" data-task-id="{{ $task->id }}"
                                   data-redirect-to="{{ request()->fullUrl() }}">
                                    <i class="fa fa-check text-info"></i> {{ trans('fi.complete-with-note') }}
                                </a>

                                <a href="javascript:void(0)" class="action-complete dropdown-item"
                                   data-task-id="{{ $task->id }}"
                                   data-tab="tasks" data-redirect-to="{{ request()->fullUrl() }}">
                                    <i class="fa fa-check"></i> {{ trans('fi.complete') }}
                                </a>
                            @else
                                <a href="javascript:void(0)" class="action-reopen dropdown-item"
                                   data-task-id="{{ $task->id }}"
                                   data-tab="tasks"
                                   data-redirect-to="{{ request()->fullUrl() }}">
                                    <i class="fa fa-check"></i> {{ trans('fi.reopen_task') }}
                                </a>
                            @endif
                            <a class="dropdown-item" href="{{ route('task.edit', [$task->id]) }}">
                                <i class="fa fa-edit"></i> {{ trans('fi.edit') }}
                            </a>
                            <div class="dropdown-divider"></div>
                            <a href="#" data-action="{{ route('task.delete', [$task->id]) }}"
                               data-redirect-to="{{ request()->fullUrl() }}"
                               data-task-id="{{ $task->id }}"
                               data-tab="tasks"
                               class="action-delete text-danger dropdown-item">
                                <i class="fa fa-trash"></i> {{ trans('fi.delete') }}
                            </a>
                        </div>
                    </div>
                @endif
            </td>
        </tr>
    @endforeach
    </tbody>
    <tfoot>
    <tr>
        <td colspan="6">
            @if(request('status'))
                <i class="fa fa-filter"></i> {{ trans('fi.n_records_match', ['label' => $tasks->count(),'plural' => $tasks->count() > 1 ? 's' : '']) }}
                <button type="button" class="btn btn-sm btn-link"
                        id="btn-clear-filters">{{ trans('fi.clear') }}
                </button>
            @endif
        </td>
    </tr>
    </tfoot>
</table>