<script type="text/javascript">
    $(function () {
        $('body #modal-merge-child-account-worn').modal();

        $('#btn-merge').click(function () {
            $('body #modal-merge-child-account-worn').modal('hide');
            showHideClientMergeLoaderModal();
            $.post('{{route('merge.set.client.record')}}',  @json($data)).done(function (response) {
                setTimeout(function () {
                    alertify.closeAll();
                    showHideClientMergeLoaderModal();
                    window.location.replace(response.redirectUrl);
                }, 3000);
                alertify.success(response.message, 5);
            }).fail(function (response) {
                showHideClientMergeLoaderModal();
                alertify.error($.parseJSON(response.responseText).message, 5);
            });
        });
    });
</script>

<div class="modal fade" id="modal-merge-child-account-worn" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog modal-lg text-break">
        <div class="modal-content">
            <div class="modal-header bg-danger">
                <h5 class="modal-title"> {{trans('fi.delete-confirm')}} </h5>
                <button type="button" class="close btn-merge-cancel" data-dismiss="modal" aria-hidden="true">
                    &times;
                </button>
            </div>
            <div class="modal-body">

                <div class="row">
                    <div class="col-md-12">
                        {!! trans('fi.merge_record_warning') !!}
                        @if(count($parentClient) > 0)
                            {!! trans('fi.merge_parent_account_warning') !!}
                        @endif
                        @if(count($invoicesPaidBy) > 0)
                            {!! trans('fi.merge_invoices_paid_by_warning') !!}
                        @endif
                        @if(($childClients->count() > 0))
                            {!! trans('fi.merge_child_account_warning') !!}
                        @endif
                        @if((count($thirdPartyBillPayers) > 0))
                            {!! trans('fi.merge_third_party_bill_payers_warning') !!}
                        @endif
                    </div>
                    <div class="col-md-12 mt-2 table-responsive">
                        @if(count($parentClient) > 0 || count($invoicesPaidBy) > 0 )

                            <div class="col-md-12 row">
                                <div class="dropdown-divider"></div>

                                @if(count($parentClient) > 0)
                                    <div class="col-md-{{$dynamicWidth}} p-0">
                                        <div class="col-md-12 p-0">
                                            <label> <i class="fa fa-link" aria-hidden="true"> </i>
                                                {!! trans('fi.parent_account') !!}
                                            </label>
                                            <span class="badge badge-primary ml-1"> {{count($parentClient)}}</span>
                                        </div>
                                        <span class="m-md-0">
                                        @foreach($parentClient as $id => $client)
                                                <a href="{{route('clients.show',['id'=>$id])}}"><span>{!! $client !!}</span></a>
                                            @endforeach
                                    </span>
                                    </div>
                                @endif
                                @if(count($invoicesPaidBy) > 0)
                                    <div class="col-md-{{$dynamicWidth}}" p-0>
                                        <div class="col-md-12 p-0">
                                            <label> <i class="fa fa-link" aria-hidden="true"> </i>
                                                {!! trans('fi.invoices_paid_by') !!}
                                            </label>
                                            <span class="badge badge-primary ml-1"> {{count($invoicesPaidBy)}}</span>
                                        </div>
                                        <span class="m-md-0">
                                        @foreach($invoicesPaidBy as $id => $client)
                                                <a href="{{route('clients.show',['id'=>$id])}}"><span>{!! $client !!}</span></a>
                                            @endforeach
                                    </span>
                                    </div>
                                @endif

                            </div>
                        @endif

                        @if(count($childClients) > 0)
                            <div class="dropdown-divider"></div>
                            <label><i class="fa-solid fa-timeline fa-rotate-180"></i> {!! trans('fi.child_account') !!}
                            </label><span class="badge badge-primary ml-1"> {{count($childClients)}}</span>
                            <table class="table table-hover table-striped table-sm text-nowrap m-0">
                                <thead>
                                <tr>
                                    <th>{{trans('fi.id')}}</th>
                                    <th>{{trans('fi.name')}}</th>
                                    <th class="text-right">{{trans('fi.active')}}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($childClients as $childClient)
                                    <tr>
                                        <td>{{$childClient->id}}</td>
                                        <td>{!! $childClient->client_name !!}</td>
                                        <td class="text-right">{!! ($childClient->active) ? "<span class='text-success'>".trans('fi.yes')."</span>" : "<span class='text-danger'>".trans('fi.no')."</span>"  !!}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        @endif
                        @if(count($thirdPartyBillPayers) > 0)
                            <div class="dropdown-divider"></div>
                            <label><i class="fa fa-credit-card"></i> {!! trans('fi.third_party_bill_payer') !!}
                            </label><span class="badge badge-primary ml-1"> {{count($thirdPartyBillPayers)}}</span>
                            <table class="table table-hover table-striped table-sm text-nowrap m-0">
                                <thead>
                                <tr>
                                    <th>{{trans('fi.id')}}</th>
                                    <th>{{trans('fi.name')}}</th>
                                    <th class="text-right">{{trans('fi.active')}}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($thirdPartyBillPayers as $client)
                                    <tr>
                                        <td>{{$client->id}}</td>
                                        <td>{!! $client->client_name !!}</td>
                                        <td class="text-right">{!! ($client->active) ? "<span class='text-success'>".trans('fi.yes')."</span>" : "<span class='text-danger'>".trans('fi.no')."</span>"  !!}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        @endif
                    </div>
                </div>
            </div>
            <div class="modal-footer pb-1 pt-1">
                <div class="col-sm-12">
                    <button type="button" id="btn-merge"
                            class="btn btn-sm btn-outline-danger float-right ml-2"
                            data-action="{{ $url }}">
                        {{ trans('fi.merge') }}
                    </button>

                    <button type="button" class="btn btn-sm btn-outline-secondary float-right btn-merge-cancel"
                            data-dismiss="modal" id="btn-merge-cancel">
                        {{ trans('fi.cancel') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>