<script type="text/javascript">
    $(function () {
        $('body #modal-merge').modal();

        $('#btn-merge').click(function () {
            $('body #modal-merge').modal('hide');
            showHideClientMergeLoaderModal();
            $.post('{{route('merge.set.client.record')}}',  @json($data)).done(function (response) {
                setTimeout(function () {
                    alertify.closeAll();
                    showHideClientMergeLoaderModal();
                    window.location.replace(response.redirectUrl);
                }, 3000);
                alertify.success(response.message, 5);
            }).fail(function (response) {
                showHideClientMergeLoaderModal();
                alertify.error($.parseJSON(response.responseText).message, 5);
            });
        });
    });
</script>

<div class="modal fade" id="modal-merge" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog text-break">
        <div class="modal-content">
            <div class="modal-header bg-danger">
                <h5 class="modal-title"> {{trans('fi.delete-confirm')}} </h5>
                <button type="button" class="close btn-merge-cancel" data-dismiss="modal" aria-hidden="true">
                    &times;
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <div class="row">
                        <div class="col-md-12">
                            {!! trans('fi.merge_record_warning') !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer pb-1 pt-1">
                <div class="col-sm-12">
                    <button type="button" id="btn-merge"
                            class="btn btn-sm btn-outline-danger float-right ml-2"
                            data-action="{{ $url }}">
                        {{ trans('fi.merge') }}
                    </button>

                    <button type="button" class="btn btn-sm btn-outline-secondary float-right btn-merge-cancel"
                            data-dismiss="modal" id="btn-merge-cancel">
                        {{ trans('fi.cancel') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>