<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Clients\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ClientGetAjaxRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'clientTo'   => 'sometimes|different:id|exists:clients,id',
            'clientFrom' => 'sometimes|different:id|exists:clients,id',
            'id'         => 'required|exists:clients,id',
        ];
    }

    public function messages()
    {
        return [
            'id.required' => trans('fi.client_id_required'),
        ];
    }
}