<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Attachments;

use FI\Modules\Attachments\Events\AddTransition;
use FI\Modules\Attachments\Events\CheckAttachment;
use FI\Modules\Transitions\Models\Transitions;
use FI\Modules\Users\Models\User;
use Illuminate\Support\Facades\Storage;

class EventSubscriber
{
    public function checkAttachment(CheckAttachment $event)
    {
        if (request()->hasFile('attachments'))
        {
            foreach (request()->file('attachments') as $attachment)
            {
                if ($attachment)
                {
                    $filename = $attachment->getClientOriginalName();

                    $media_path = Storage::disk('media')->put($event->object->getTable(), $attachment);

                    $user_id = auth()->user()->id;

                    $response = $event->object->attachments()->create([
                        'user_id'    => $user_id,
                        'media_path' => $media_path,
                        'filename'   => $filename,
                        'mimetype'   => $attachment->getMimeType(),
                        'size'       => $attachment->getSize(),
                    ]);

                    $transition                      = new Transitions();
                    $transition->user_id             = $user_id;
                    $transition->client_id           = isset($event->object->id) ? $event->object->id : null;
                    $transition->transitionable_id   = $response->id;
                    $transition->transitionable_type = 'FI\Modules\Attachments\Models\Attachment';
                    $transition->action_type         = 'created';
                    $transition->detail              = json_encode([
                        'filename'        => $filename,
                        'client_name'     => $event->object->name,
                        'client_id'       => $event->object->id,
                        'attachment_link' => $response->getDownloadUrlAttribute()
                    ]);
                    $transition->save();
                }

            }
        }
    }

    public function addTransition(AddTransition $event)
    {
        $userId                          = isset(auth()->user()->id) ? auth()->id() : User::whereUserType('system')->first()->id;
        $transition                      = new Transitions();
        $transition->user_id             = $userId;
        $transition->client_id           = isset($event->attachment->attachable->id) ? $event->attachment->attachable->id : null;
        $transition->transitionable_id   = $event->attachment->id;
        $transition->transitionable_type = 'FI\Modules\Attachments\Models\Attachment';
        $transition->action_type         = $event->actionType;
        $transition->detail              = json_encode($event->detail);
        $transition->save();

    }

    public function subscribe($events)
    {
        $events->listen('FI\Modules\Attachments\Events\AddTransition', 'FI\Modules\Attachments\EventSubscriber@AddTransition');
        $events->listen('FI\Modules\Attachments\Events\CheckAttachment', 'FI\Modules\Attachments\EventSubscriber@checkAttachment');
    }
}