<?php

namespace FI\Jobs;

use FI\Mail\OtpMail;
use Illuminate\Bus\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class SendOtpEmailJob
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

//    TODO: We have not make this job Queueable as our dynamic Email configuration
//    are not accessible on default laravel Queueable job.
//    To make it working with Queueable job we have already implemented code on our SupportTicket addon
//    and comment out for the time.

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $email = new OtpMail($this->data);

        Mail::to($this->data['email'])->send($email);
    }
}
