<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use FI\Modules\ItemLookups\Models\ItemLookup;

function itemLookUpsDropDown($default = '', $class = '')
{
    $items       = ItemLookup::all();
    $defaultItem = $default != '' ? ItemLookup::whereName($default->name)->first() : null;
    // $dropDown    = '<select class="form-control form-control-sm copy-to-clipboard ' . $class . ' " name="name" style="width: initial; display: inline; ">';
    $dropDown    = '<select class="form-control form-control-sm copy-to-clipboard ' . $class . ' " name="name" style="max-width: 85%; display: inline;">';
    $dropDown .= '<option></option>';
    $defaultItemId = false;
    foreach ($items as $item)
    {

        if ($defaultItem != '' && $item->id == $defaultItem->id)
        {
            $dropDown .= '<option value="' . $item->id . '" selected>' . $item->name . '</option>';
            $defaultItemId = true;
        }
        else
        {
            $dropDown .= '<option value="' . $item->id . '">' . $item->name . '</option>';
        }
    }

    if ($default != '' && $defaultItemId == false)
    {
        $dropDown .= '<option value="' . $default->name . '" data-item_id="' . $default->id . '" selected>' . $default->name . '</option>';
    }
    $dropDown .= '</select>';

    return $dropDown;
}