<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;

/**
 * @return array|string[]
 */

function databaseConnections()
{
    $dbNames = array_keys(config('database.connections'));

    $modifiedDbNames = array_map(function ($value) {
        if ($value == 'mysql')
        {
            $value = 'Default';
        }
        return ucwords(str_replace('_', ' ', $value));
    }, $dbNames);

    return ['' => 'Select Database'] + array_combine($dbNames, $modifiedDbNames);
}

function databaseConnectionChanger($request = null)
{
    if (config('app.demo'))
    {
        try
        {
            if (request()->has('database') && request('database') != '')
            {
                DB::setDefaultConnection(request('database'));
                Cookie::queue('database_select', request('database'));
            }
            else if ($request->cookie('database_select') != '')
            {
                $database = (explode('|', Crypt::decryptString($request->cookie('database_select'))))[1];
                DB::setDefaultConnection($database);
            }
            else
            {
                DB::setDefaultConnection('mysql');
            }
        }
        catch (\Exception $e)
        {
            DB::setDefaultConnection('mysql');
        }
    }

}

